/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.comment;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.EvidencedValue;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.EvidencedStringType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.comment.CommentXmlTextHelper;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class EvidencedValueHandler
implements GenericHandler<EvidencedValue, EvidencedStringType> {
    private final ObjectFactory objectFactory;
    private final EvidenceReferenceHandler evRefHandler;
    private final boolean text2Xml;

    public EvidencedValueHandler(ObjectFactory objectFactory, EvidenceReferenceHandler referenceHandler) {
        this(objectFactory, referenceHandler, false);
    }

    public EvidencedValueHandler(ObjectFactory objectFactory, EvidenceReferenceHandler referenceHandler, boolean text2Xml) {
        this.objectFactory = objectFactory;
        this.evRefHandler = referenceHandler;
        this.text2Xml = text2Xml;
    }

    @Override
    public EvidencedValue fromXmlBinding(EvidencedStringType xmlObject) {
        String value = xmlObject.getValue();
        List<Object> evidences = null;
        evidences = !xmlObject.getEvidence().isEmpty() ? this.evRefHandler.parseEvidenceIDs(xmlObject.getEvidence()) : new ArrayList();
        EvidencedValue evValue = DefaultUniProtFactory.getInstance().buildEvidencedValue();
        if (this.text2Xml) {
            evValue.setValue(CommentXmlTextHelper.convertTextFromXml(value));
        } else {
            evValue.setValue(value);
        }
        evValue.setEvidenceIds(evidences);
        return evValue;
    }

    @Override
    public EvidencedStringType toXmlBinding(EvidencedValue object) {
        EvidencedStringType textType = this.objectFactory.createEvidencedStringType();
        if (this.text2Xml) {
            textType.setValue(CommentXmlTextHelper.convertTextToXml(object.getValue()));
        } else {
            textType.setValue(object.getValue());
        }
        if (!object.getEvidenceIds().isEmpty()) {
            List<Integer> evs = this.evRefHandler.writeEvidenceIDs(object.getEvidenceIds());
            textType.getEvidence().addAll(evs);
        }
        return textType;
    }
}

