/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot;

import com.sun.xml.bind.marshaller.DataWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.DatatypeConverterInterface;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.xml.sax.ContentHandler;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.parser.EntryIterator;
import uk.ac.ebi.kraken.parser.UniProtEntryIteratorException;
import uk.ac.ebi.kraken.xml.common.KrakenDatatypeConverter;
import uk.ac.ebi.kraken.xml.common.XMLWriterException;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.Entry;
import uk.ac.ebi.kraken.xml.uniprot.KeyListProxyFromXml;
import uk.ac.ebi.kraken.xml.uniprot.UniProtEntryHandler;
import uk.ac.ebi.kraken.xml.uniprot.UniProtXMLProperties;
import uk.ac.ebi.kraken.xml.uniprot.comment.humdiseaselist.DiseaseIdListRetrieval;

public class UniProtXMLWriter {
    private static final String header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<uniprot xmlns=\"http://uniprot.org/uniprot\"\n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n xsi:schemaLocation=\"http://uniprot.org/uniprot http://www.uniprot.org/docs/uniprot.xsd\">\n";
    private static final String footer = "</uniprot>";
    private Writer writer;
    private UniProtEntryHandler entryHandler;
    private JAXBContext jaxbContext;
    private DiseaseIdListRetrieval diseaseIdListRetrieval;
    private boolean writeHeaderFooter = true;
    private List<String> unparsedEntries;
    private List<String> invalidEntries;
    private UniProtXMLProperties properties;
    private boolean quiet = false;
    private Marshaller marshaller;

    public UniProtXMLWriter(Writer writer) {
        this.init(writer);
    }

    private void init(Writer writer) {
        this.writer = writer;
        this.unparsedEntries = new ArrayList<String>();
        this.invalidEntries = new ArrayList<String>();
    }

    public void write(UniProtEntry entry) throws IOException {
        if (entry == null) {
            throw new IllegalArgumentException("Entry to convert should not be null");
        }
        if (this.writeHeaderFooter) {
            this.writeHeader();
        }
        this.writeEntry(entry, this.getXMLWriter(this.writer));
        if (this.writeHeaderFooter) {
            this.writeFooter();
        }
    }

    public void write(EntryIterator iterator) throws IOException {
        if (this.writeHeaderFooter) {
            this.writeHeader();
        }
        DataWriter xmlWriter = this.getXMLWriter(this.writer);
        UniProtEntry entry = null;
        if (!iterator.hasNext()) {
            this.unparsedEntries.add("Input file cointains no valid entries");
        }
        while (iterator.hasNext()) {
            try {
                entry = iterator.next();
                this.writeEntry(entry, xmlWriter);
            }
            catch (UniProtEntryIteratorException e) {
                this.unparsedEntries.add(e.getUnparsedEntry() + "\n" + e.getMessage());
                System.err.println("FF entry is not parsed. Check unparsedEntries list");
            }
            catch (XMLWriterException e) {
                System.err.println("Entry is not converted to XML. Check invalidEntries list");
                this.addInvalidEntry(entry, e.getMessage());
            }
        }
        if (this.writeHeaderFooter) {
            this.writeFooter();
        }
    }

    public void write(EntryIterator iterator, int limit) throws IOException {
        if (this.writeHeaderFooter) {
            this.writeHeader();
        }
        DataWriter xmlWriter = this.getXMLWriter(this.writer);
        UniProtEntry entry = null;
        if (!iterator.hasNext()) {
            this.unparsedEntries.add("Input file cointains no valid entries");
        }
        int counter = 0;
        while (iterator.hasNext()) {
            try {
                entry = iterator.next();
                this.writeEntry(entry, xmlWriter);
                if (++counter != limit) continue;
                break;
            }
            catch (UniProtEntryIteratorException e) {
                this.unparsedEntries.add(e.getUnparsedEntry() + "\n" + e.getMessage());
                System.err.println("FF entry is not parsed. Check unparsedEntries list");
            }
            catch (XMLWriterException e) {
                System.err.println("Entry is not converted to XML. Check invalidEntries list");
                this.addInvalidEntry(entry, e.getMessage());
            }
        }
        if (this.writeHeaderFooter) {
            this.writeFooter();
        }
    }

    public UniProtXMLProperties getProperties() {
        return this.properties;
    }

    public void setProperties(UniProtXMLProperties properties) {
        this.properties = properties;
    }

    public void writeFooter() throws IOException {
        this.writer.append(footer);
    }

    public void writeHeader() throws IOException {
        this.writer.append(header);
    }

    private void writeEntry(UniProtEntry entry, DataWriter xmlWriter) {
        Marshaller m = this.prepareSpecialMarshaller();
        if (this.entryHandler == null) {
            if (this.diseaseIdListRetrieval == null || this.properties == null) {
                throw new RuntimeException("The disease retrieval list and/or properties are null");
            }
            this.entryHandler = UniProtEntryHandler.getInstance(this.diseaseIdListRetrieval, this.getKeyListProxyImpl());
        }
        try {
            Entry xmlEntry = this.entryHandler.toXmlBinding(entry);
            xmlWriter.reset();
            m.marshal((Object)xmlEntry, (ContentHandler)xmlWriter);
        }
        catch (JAXBException e) {
            throw new XMLWriterException("Entry was not converted to XML: " + (Object)((Object)e), e, entry.getUniProtId().getValue());
        }
    }

    private KeyListProxyFromXml getKeyListProxyImpl() {
        String fileName = this.getProperties().getProperty("keywordlist.file.name");
        KeyListProxyFromXml keyListProxy = new KeyListProxyFromXml();
        keyListProxy.setFileName(fileName);
        return keyListProxy;
    }

    private void addInvalidEntry(UniProtEntry entry, String message) {
        StringBuilder sb = new StringBuilder();
        if (entry != null) {
            sb.append(entry.getUniProtId().getValue());
        }
        sb.append("\n");
        sb.append(message);
        this.invalidEntries.add(sb.toString());
    }

    private JAXBContext getJaxbContext() throws JAXBException {
        if (this.jaxbContext == null) {
            DatatypeConverter.setDatatypeConverter((DatatypeConverterInterface)new KrakenDatatypeConverter());
            this.jaxbContext = JAXBContext.newInstance((String)"uk.ac.ebi.kraken.xml.jaxb.uniprot");
        }
        return this.jaxbContext;
    }

    protected Marshaller prepareSpecialMarshaller() {
        try {
            if (this.marshaller == null) {
                Marshaller m = this.getJaxbContext().createMarshaller();
                DatatypeConverter.setDatatypeConverter((DatatypeConverterInterface)new KrakenDatatypeConverter());
                m.setProperty("com.sun.xml.bind.xmlDeclaration", (Object)Boolean.FALSE);
                m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                this.marshaller = m;
            }
        }
        catch (JAXBException e) {
            throw new XMLWriterException("Cannot initiate Marshaller", e);
        }
        return this.marshaller;
    }

    private DataWriter getXMLWriter(Writer out) {
        DataWriter writer = new DataWriter(out, "UTF-8");
        writer.setIndentStep("  ");
        return writer;
    }

    public void setWriteHeaderFooter(boolean b) {
        this.writeHeaderFooter = b;
    }

    public List<String> getUnparsedEntries() {
        return this.unparsedEntries;
    }

    public List<String> getInvalidEntries() {
        return this.invalidEntries;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void setDiseaseIdListRetrieval(DiseaseIdListRetrieval diseaseIdListRetrieval) {
        this.diseaseIdListRetrieval = diseaseIdListRetrieval;
    }
}

