/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.DatatypeConverterInterface;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import uk.ac.ebi.kraken.interfaces.factories.KeywordListFactory;
import uk.ac.ebi.kraken.interfaces.keywordlist.GoId;
import uk.ac.ebi.kraken.interfaces.keywordlist.GoMapping;
import uk.ac.ebi.kraken.interfaces.keywordlist.KeywordAccession;
import uk.ac.ebi.kraken.interfaces.keywordlist.KeywordDescription;
import uk.ac.ebi.kraken.interfaces.keywordlist.KeywordEntry;
import uk.ac.ebi.kraken.interfaces.keywordlist.KeywordIdentifier;
import uk.ac.ebi.kraken.interfaces.keywordlist.KeywordSynonym;
import uk.ac.ebi.kraken.model.factories.DefaultKeywordListFactory;
import uk.ac.ebi.kraken.xml.common.KrakenDatatypeConverter;
import uk.ac.ebi.kraken.xml.jaxb.keywordlist.KeywordList;
import uk.ac.ebi.kraken.xml.jaxb.keywordlist.ObjectFactory;

public class KeywordListConverter {
    private KeywordListFactory factory;
    private static JAXBContext jaxbContext;
    private ObjectFactory objectFactory;

    public KeywordListConverter() throws JAXBException {
        this(DefaultKeywordListFactory.getInstance());
    }

    public KeywordListConverter(KeywordListFactory factory) throws JAXBException {
        this.factory = factory;
        jaxbContext = JAXBContext.newInstance((String)"uk.ac.ebi.kraken.xml.jaxb.keywordlist");
        this.objectFactory = new ObjectFactory();
    }

    public void toJAXB(KeywordEntry keywordEntry, KeywordList.Keyword xmlKeyword) {
        xmlKeyword.setId(keywordEntry.getAccession().getValue());
        xmlKeyword.getName().add(keywordEntry.getIdentifier().getValue());
        Set<KeywordSynonym> synonyms = keywordEntry.getSynonyms();
        for (KeywordSynonym keywordSynonym : synonyms) {
            xmlKeyword.getName().add(keywordSynonym.getValue());
        }
        xmlKeyword.setDescription(keywordEntry.getDescription().getValue());
        Set<GoMapping> goMappings = keywordEntry.getGoMappings();
        for (GoMapping goMapping : goMappings) {
            KeywordList.Keyword.Go xmlGo = this.objectFactory.createKeywordListKeywordGo();
            xmlGo.setId(goMapping.getGoId().getValue());
            xmlKeyword.getGo().add(xmlGo);
        }
    }

    public void fromJAXB(KeywordEntry keywordEntry, KeywordList.Keyword xmlKeyword) {
        KeywordAccession accession = this.factory.buildAccession(xmlKeyword.getId());
        keywordEntry.setAccession(accession);
        KeywordDescription description = this.factory.buildDescription(xmlKeyword.getDescription());
        keywordEntry.setDescription(description);
        List<String> names = xmlKeyword.getName();
        KeywordIdentifier identifier = this.factory.buildIdentifier(names.get(0));
        keywordEntry.setIdentifier(identifier);
        for (int i = 1; i < names.size(); ++i) {
            KeywordSynonym synonym = this.factory.buildSynonym(names.get(i));
            keywordEntry.getSynonyms().add(synonym);
        }
        List<KeywordList.Keyword.Go> goEntries = xmlKeyword.getGo();
        Iterator<KeywordList.Keyword.Go> iterator = goEntries.iterator();
        while (iterator.hasNext()) {
            KeywordList.Keyword.Go o;
            KeywordList.Keyword.Go xmlGo = o = iterator.next();
            GoMapping goMapping = this.factory.buildGoMapping();
            GoId goId = this.factory.buildGoId(xmlGo.getId());
            goMapping.setGoId(goId);
            keywordEntry.getGoMappings().add(goMapping);
        }
    }

    public List<KeywordEntry> readKeywordList(File kwListFile) throws JAXBException {
        ArrayList<KeywordEntry> kwEntries = new ArrayList<KeywordEntry>();
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        BufferedReader in = null;
        try {
            in = kwListFile.getName().endsWith(".gzip") || kwListFile.getName().endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(kwListFile))), 16384) : new BufferedReader(new FileReader(kwListFile), 16384);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        KeywordList xmlKeywords = (KeywordList)unmarshaller.unmarshal((Reader)in);
        for (KeywordList.Keyword xmlKeyword : xmlKeywords.getKeyword()) {
            KeywordEntry keywordEntry = this.factory.buildEntry();
            this.fromJAXB(keywordEntry, xmlKeyword);
            kwEntries.add(keywordEntry);
        }
        return kwEntries;
    }

    public void writeKeywordList(String outputFileName, Collection<KeywordEntry> kwEntries) throws JAXBException, IOException {
        Marshaller marshaller = this.getMarshaller();
        FileOutputStream out = new FileOutputStream(outputFileName);
        KeywordList xmlKeywordList = this.objectFactory.createKeywordList();
        for (KeywordEntry keywordEntry : kwEntries) {
            KeywordList.Keyword xmlKeyword = this.objectFactory.createKeywordListKeyword();
            this.toJAXB(keywordEntry, xmlKeyword);
            xmlKeywordList.getKeyword().add(xmlKeyword);
        }
        marshaller.marshal((Object)xmlKeywordList, (OutputStream)out);
        ((OutputStream)out).close();
    }

    protected Marshaller getMarshaller() throws JAXBException {
        Marshaller m = jaxbContext.createMarshaller();
        DatatypeConverter.setDatatypeConverter((DatatypeConverterInterface)new KrakenDatatypeConverter());
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        return m;
    }
}

