/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniparc;

import com.google.common.base.Strings;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import uk.ac.ebi.kraken.interfaces.common.Database;
import uk.ac.ebi.kraken.interfaces.common.Sequence;
import uk.ac.ebi.kraken.interfaces.factories.UniParcFactory;
import uk.ac.ebi.kraken.interfaces.uniparc.DatabaseCrossReference;
import uk.ac.ebi.kraken.interfaces.uniparc.UniParcEntry;
import uk.ac.ebi.kraken.interfaces.uniparc.UniParcId;
import uk.ac.ebi.kraken.model.factories.DefaultUniParcFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniparc.DbReferenceType;
import uk.ac.ebi.kraken.xml.jaxb.uniparc.Entry;
import uk.ac.ebi.kraken.xml.jaxb.uniparc.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniparc.PropertyType;
import uk.ac.ebi.kraken.xml.jaxb.uniparc.Uniparc;
import uk.ac.ebi.kraken.xml.uniparc.SequenceFeatureConverter;
import uk.ac.ebi.kraken.xml.uniprot.XMLKrakenConverter;

public class UniParcEntryJAXBConverter
extends XMLKrakenConverter<UniParcEntry, Entry> {
    private static final String GENE_NAME = "gene_name";
    private static final String PROTEIN_NAME = "protein_name";
    private static final String UNI_PROT_KB_ACCESSION = "UniProtKB_accession";
    private static final String CHAIN = "chain";
    private static final String NCBI_GI = "NCBI_GI";
    private static final String PROTEOME_ID = "proteome_id";
    private static final String COMPONENT = "component";
    private static final String NCBI_TAXONOMY_ID = "NCBI_taxonomy_id";
    private static UniParcEntryJAXBConverter singletonInstance;
    private ThreadLocal<DateFormat> dateFormatter = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };
    private final ObjectFactory objectFactory = new ObjectFactory();
    private final UniParcFactory uniParcFactory = DefaultUniParcFactory.getInstance();
    private final SequenceFeatureConverter seqFeatureConverter = new SequenceFeatureConverter();

    protected UniParcEntryJAXBConverter() {
    }

    public static UniParcEntryJAXBConverter getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new UniParcEntryJAXBConverter();
        }
        return singletonInstance;
    }

    @Override
    public void fromJAXB(Entry xmlEntry, UniParcEntry uniParcEntry) throws JAXBException {
        try {
            this.convert(xmlEntry, uniParcEntry);
        }
        catch (ParseException e) {
            throw new JAXBException("Parser problems with the UniParc dates..", (Throwable)e);
        }
    }

    @Override
    public void toJAXB(UniParcEntry uniParcEntry, Entry xmlEntry) throws JAXBException {
        this.convert(uniParcEntry, xmlEntry);
    }

    public String toXML(UniParcEntry entry) {
        StringWriter resultWriter = new StringWriter();
        try {
            Uniparc uniparc = this.objectFactory.createUniparc();
            Entry xmlEntry = this.objectFactory.createEntry();
            this.convert(entry, xmlEntry);
            uniparc.getEntry().add(xmlEntry);
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"uk.ac.ebi.kraken.xml.jaxb.uniparc");
            Marshaller m = jaxbContext.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)uniparc, (Writer)resultWriter);
        }
        catch (JAXBException e) {
            System.err.println(e.getMessage());
        }
        return resultWriter.toString();
    }

    public String toHTMLForm(UniParcEntry entry) {
        String xml = this.toXML(entry);
        StringBuilder result = new StringBuilder();
        block6: for (int iii = 0; iii < xml.length(); ++iii) {
            char c = xml.charAt(iii);
            switch (c) {
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '>': {
                    result.append("&gt;");
                    continue block6;
                }
                case '&': {
                    result.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    result.append("&#034;");
                    continue block6;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    private UniParcEntry convert(Entry theEntry, UniParcEntry entry) throws ParseException {
        UniParcId uid = this.uniParcFactory.buildUniParcId(theEntry.getAccession());
        entry.setUniParcId(uid);
        String seqString = theEntry.getSequence().getContent();
        StringBuffer realSequence = new StringBuffer();
        for (int iii = 0; iii < seqString.length(); ++iii) {
            char c = seqString.charAt(iii);
            if (c == '\t' || c == '\n') continue;
            realSequence.append(c);
        }
        Sequence resultSequence = this.uniParcFactory.buildSequence();
        resultSequence.setValue(realSequence.toString().replaceAll(" ", ""));
        resultSequence.setCRC64(theEntry.getSequence().getChecksum());
        entry.setSequence(resultSequence);
        for (DbReferenceType referenceType : theEntry.getDbReference()) {
            entry.getDatabaseCrossReferences().add(this.convert(referenceType));
        }
        entry.setSequenceFeatures(theEntry.getSignatureSequenceMatch().stream().map(this.seqFeatureConverter::fromXml).collect(Collectors.toList()));
        return entry;
    }

    private DatabaseCrossReference convert(DbReferenceType ref) throws ParseException {
        DatabaseCrossReference result = this.uniParcFactory.buildDatabaseCrossReference();
        Database db = this.uniParcFactory.buildDatabase();
        db.setName(ref.getType());
        result.setDatabase(db);
        result.setAccession(ref.getId());
        result.setInternalVersion(ref.getVersionI());
        result.setActive(ref.getActive().equals("Y"));
        if (ref.getVersion() != null) {
            result.setVersion(ref.getVersion());
            db.setVersion(ref.getVersion());
        }
        if (ref.getCreated() != null) {
            result.setCreated(this.dateFormatter.get().parse(ref.getCreated().toString()));
        }
        if (ref.getLast() != null) {
            result.setUpdated(this.dateFormatter.get().parse(ref.getLast().toString()));
        }
        boolean setTaxId = false;
        for (PropertyType prop : ref.getProperty()) {
            if (NCBI_TAXONOMY_ID.equals(prop.getType())) {
                if (!setTaxId) {
                    result.setTaxonomyId(Integer.parseInt(prop.getValue()));
                    setTaxId = true;
                } else {
                    result.getExtraTaxonomyIds().add(Integer.parseInt(prop.getValue()));
                }
            }
            if (NCBI_GI.equals(prop.getType())) {
                result.setGiNumber(prop.getValue());
            }
            if (CHAIN.equals(prop.getType())) {
                result.setChain(prop.getValue());
            }
            if (UNI_PROT_KB_ACCESSION.equals(prop.getType())) {
                result.setUniProtAccession(prop.getValue());
            }
            if (PROTEIN_NAME.equals(prop.getType())) {
                result.setProteinName(prop.getValue());
            }
            if (GENE_NAME.equals(prop.getType())) {
                result.setGeneName(prop.getValue());
            }
            if (PROTEOME_ID.equals(prop.getType())) {
                result.setProteome(prop.getValue());
            }
            if (!COMPONENT.equals(prop.getType())) continue;
            result.setProteomeComponent(prop.getValue());
        }
        return result;
    }

    private Entry convert(UniParcEntry entry, Entry xmlEntry) {
        xmlEntry.setAccession(entry.getUniParcId().getValue());
        xmlEntry.setDataset("uniparc");
        Set<DatabaseCrossReference> refs = entry.getDatabaseCrossReferences();
        for (DatabaseCrossReference reference : refs) {
            xmlEntry.getDbReference().add(this.convert(reference));
        }
        uk.ac.ebi.kraken.xml.jaxb.uniparc.Sequence sequence = this.objectFactory.createSequence();
        String rawSequence = entry.getSequence().getValue();
        sequence.setContent(rawSequence);
        sequence.setLength(entry.getSequence().getLength());
        sequence.setChecksum(entry.getSequence().getCRC64());
        xmlEntry.setSequence(sequence);
        entry.getSequenceFeatures().stream().map(this.seqFeatureConverter::toXml).forEach(xmlEntry.getSignatureSequenceMatch()::add);
        return xmlEntry;
    }

    private DbReferenceType convert(DatabaseCrossReference ref) {
        PropertyType type;
        DbReferenceType result = this.objectFactory.createDbReferenceType();
        result.setType(ref.getDatabase().getName());
        result.setId(ref.getAccession());
        result.setVersionI(ref.getInternalVersion());
        if (ref.isActive()) {
            result.setActive("Y");
        } else {
            result.setActive("N");
        }
        try {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(ref.getCreated());
            result.setCreated(DatatypeFactory.newInstance().newXMLGregorianCalendar(cal));
            cal = new GregorianCalendar();
            cal.setTime(ref.getUpdated());
            result.setLast(DatatypeFactory.newInstance().newXMLGregorianCalendar(cal));
        }
        catch (DatatypeConfigurationException e) {
            new JAXBException("Unable to convert dates", (Throwable)e);
        }
        if (ref.getVersion() > 0) {
            result.setVersion(ref.getVersion());
        }
        if (!ref.getChain().equals("")) {
            type = this.objectFactory.createPropertyType();
            type.setType(CHAIN);
            type.setValue(ref.getChain());
            result.getProperty().add(type);
        }
        if (!ref.getGiNumber().equals("")) {
            type = this.objectFactory.createPropertyType();
            type.setType(NCBI_GI);
            type.setValue(ref.getGiNumber());
            result.getProperty().add(type);
        }
        if (ref.getTaxonomyId() > 0) {
            type = this.objectFactory.createPropertyType();
            type.setType(NCBI_TAXONOMY_ID);
            type.setValue(String.valueOf(ref.getTaxonomyId()));
            result.getProperty().add(type);
        }
        if (!ref.getUniProtAccession().equals("")) {
            type = this.objectFactory.createPropertyType();
            type.setType(UNI_PROT_KB_ACCESSION);
            type.setValue(ref.getUniProtAccession());
            result.getProperty().add(type);
        }
        if (!Strings.isNullOrEmpty((String)ref.getGeneName())) {
            type = this.objectFactory.createPropertyType();
            type.setType(GENE_NAME);
            type.setValue(ref.getGeneName());
            result.getProperty().add(type);
        }
        if (!Strings.isNullOrEmpty((String)ref.getProteinName())) {
            type = this.objectFactory.createPropertyType();
            type.setType(PROTEIN_NAME);
            type.setValue(ref.getProteinName());
            result.getProperty().add(type);
        }
        if (!Strings.isNullOrEmpty((String)ref.getProteome())) {
            type = this.objectFactory.createPropertyType();
            type.setType(PROTEOME_ID);
            type.setValue(ref.getProteome());
            result.getProperty().add(type);
        }
        if (!Strings.isNullOrEmpty((String)ref.getProteomeComponent())) {
            type = this.objectFactory.createPropertyType();
            type.setType(COMPONENT);
            type.setValue(ref.getProteomeComponent());
            result.getProperty().add(type);
        }
        return result;
    }
}

