/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.string;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.kraken.util.GreekAlphabetConvertor;

public class NonAscii2AsciiConverter {
    private static Map<Integer, String> nonAscii2AsciiMap = new HashMap<Integer, String>();
    private static final Logger LOG = LoggerFactory.getLogger(NonAscii2AsciiConverter.class);

    private NonAscii2AsciiConverter() {
    }

    public static String convert(String val) {
        String newVal = GreekAlphabetConvertor.replaceAllGreekChars(val);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < newVal.length(); ++i) {
            char chVal = newVal.charAt(i);
            if (chVal < '\u0080' && chVal >= '\u0000') {
                sb.append(chVal);
                continue;
            }
            String mapped = nonAscii2AsciiMap.get(chVal);
            if (mapped == null) continue;
            sb.append(mapped);
        }
        return sb.toString();
    }

    static {
        String filename = "latin1.txt";
        try (BufferedReader bif = new BufferedReader(new InputStreamReader(NonAscii2AsciiConverter.class.getClassLoader().getResourceAsStream(filename)));){
            if (bif != null) {
                String l;
                while ((l = bif.readLine()) != null) {
                    if (l.startsWith("#") || l.length() == 0) continue;
                    String[] tokens = l.split("\t");
                    if (tokens.length != 2) {
                        System.out.println("Wrong line: " + l);
                        continue;
                    }
                    nonAscii2AsciiMap.put(Integer.parseInt(tokens[0]), tokens[1]);
                }
            }
        }
        catch (IOException e) {
            LOG.warn(e.getMessage());
        }
    }
}

