/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.parser;

import java.util.regex.Pattern;

public class DecapitaliseFirstLetterParser {
    private static Pattern exceptions = Pattern.compile("(^Von|^[MTRC][RD]NA|^SnRNA|^SnoRNP|^SNPF|^C[AGN]MP[^a-zA-Z]|^C-Myc|^FMet|^D[ACGTU][MDT]P[^a-zA-Z]|^DUTPase|^MTERF|^P-\\w+|^P2L|^T-SNARE|^Snb|^PrM|^O-phtalyl).+");
    private static Pattern exceptionsOfExceptions = Pattern.compile("(^P-loop|^P-protein|^P-type|^P-beta|^P-450|^P-element|^P-II|^P-selectin|^P-starvation|^P-ATPase|^P-cell|^P-Rib-PP).+");

    public static String parse(String val) {
        String localVal = val;
        if (localVal == null) {
            return null;
        }
        if (exceptions.matcher(localVal).matches() && !exceptionsOfExceptions.matcher(localVal).matches()) {
            char[] c = localVal.toCharArray();
            c[0] = (char)(c[0] + 32);
            localVal = new String(c);
        }
        localVal = localVal.replaceAll("DUTP pyro", "dUTP pyro");
        localVal = localVal.replaceAll("DUTPase", "dUTPase");
        localVal = localVal.replaceAll("von \\(von\\)", "von");
        localVal = localVal.replaceAll("T-SNARE", "t-SNARE");
        return localVal;
    }
}

