/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.jaxb;

import java.io.InputStream;
import java.util.Iterator;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlIterator<T>
implements Iterator<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlIterator.class);
    private T xmlEntry;
    private final XMLStreamReader staxStreamReader;
    protected final Unmarshaller unmarshaller;
    private final Class<T> clazz;
    private final String startElement;

    public XmlIterator(InputStream inputStream, Class<T> clazz, String startElement) throws XMLStreamException, JAXBException {
        XMLInputFactory xif = XMLInputFactory.newFactory();
        this.staxStreamReader = xif.createXMLStreamReader(inputStream);
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
        this.unmarshaller = jaxbContext.createUnmarshaller();
        this.clazz = clazz;
        this.startElement = startElement;
    }

    @Override
    public boolean hasNext() {
        boolean result;
        if (this.xmlEntry == null) {
            this.xmlEntry = this.getNextEntry();
        }
        boolean bl = result = this.xmlEntry != null;
        if (!result) {
            try {
                this.staxStreamReader.close();
            }
            catch (XMLStreamException e) {
                LOGGER.warn("error while closing stax stream", (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public T next() {
        T xmlEntry = this.xmlEntry;
        this.xmlEntry = this.getNextEntry();
        return xmlEntry;
    }

    private T getNextEntry() {
        try {
            while (this.staxStreamReader.hasNext() && (this.staxStreamReader.getEventType() != 1 || !this.staxStreamReader.getLocalName().equals(this.startElement))) {
                this.staxStreamReader.next();
            }
            if (this.staxStreamReader.getEventType() == 8) {
                return null;
            }
            JAXBElement treeObject = this.unmarshaller.unmarshal(this.staxStreamReader, this.clazz);
            if (treeObject != null) {
                return (T)treeObject.getValue();
            }
            return null;
        }
        catch (JAXBException | XMLStreamException e) {
            LOGGER.error("Parser error " + e);
            return null;
        }
    }
}

