/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.parser;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.features.CarbohydFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.CarbohydLinkType;
import uk.ac.ebi.kraken.interfaces.uniprot.features.ConflictFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.ConflictReport;
import uk.ac.ebi.kraken.interfaces.uniprot.features.Feature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureSequence;
import uk.ac.ebi.kraken.interfaces.uniprot.features.HasAlternativeSequence;
import uk.ac.ebi.kraken.interfaces.uniprot.features.HasFeatureDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.features.HasFeatureId;
import uk.ac.ebi.kraken.interfaces.uniprot.features.MutagenFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.VarSeqFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.VariantFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.VariantReport;
import uk.ac.ebi.kraken.interfaces.uniprot.features.VarsplicIsoform;
import uk.ac.ebi.kraken.model.factories.DefaultFeatureFactory;

public class FeatureHelper {
    private static final String FT_ID = "/FTId=";
    private static final String MISSING = "Missing";
    private static final String SEMICOLON = ";";
    private static final String COMMA = ",";
    private static final String STOP = ".";
    private static final String LINE_END = "\n";
    private static final String BRACKET_RIGHT = ")";
    private static final String BRACKET_LEFT = "(";
    private static final String PROBABLE4 = "(Probable)";
    private static final String PROBABLE3 = "(Probable).";
    private static final String PROBABLE2 = "Probable";
    private static final String PROBABLE = "Probable.";
    private static final String POTENTIAL4 = "(Potential)";
    private static final String POTENTIAL3 = "(Potential).";
    private static final String POTENTIAL2 = "Potential";
    private static final String POTENTIAL = "Potential.";
    private static final String BY_SIMILARITY4 = "(By similarity)";
    private static final String BY_SIMILARITY3 = "(By similarity).";
    private static final String BY_SIMILARITY2 = "By similarity";
    private static final String BY_SIMILARITY = "By similarity.";
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureHelper.class);

    public static void parseDescription(Feature result, String annotation) {
        if (result instanceof HasFeatureId) {
            annotation = FeatureHelper.consumeFeatureId((HasFeatureId)result, annotation);
        }
        if (!Strings.isNullOrEmpty((String)annotation)) {
            annotation = annotation.trim();
        }
        if (result instanceof CarbohydFeature) {
            annotation = FeatureHelper.consumeCarbohydFeature((CarbohydFeature)result, annotation);
        }
        if ((annotation = FeatureHelper.removeEnd(annotation, LINE_END)).endsWith(STOP)) {
            if (result instanceof MutagenFeature) {
                annotation = FeatureHelper.consumeMutagenReport((MutagenFeature)result, annotation.substring(0, annotation.length() - 1));
            } else if (result instanceof VariantFeature) {
                annotation = FeatureHelper.consumeVariantReport((VariantFeature)result, annotation.substring(0, annotation.length() - 1));
            } else if (result instanceof VarSeqFeature) {
                annotation = FeatureHelper.consumeVarSplicFeature((VarSeqFeature)result, annotation.substring(0, annotation.length() - 1));
            } else if (result instanceof ConflictFeature) {
                annotation = FeatureHelper.consumeConflictReport((ConflictFeature)result, annotation.substring(0, annotation.length() - 1));
            }
        }
        annotation = FeatureHelper.removeEnd(annotation, STOP);
        annotation = FeatureHelper.consumeAlternativeSequence2(result, annotation.trim());
        FeatureHelper.setDescription(result, annotation);
    }

    private static String consumeAlternativeSequence2(Feature feature, String annotation) {
        if (feature instanceof HasAlternativeSequence) {
            FeatureHelper.consumeAlternativeSequence((HasAlternativeSequence)feature, annotation);
            return "";
        }
        return annotation;
    }

    private static void setDescription(Feature feature, String annotation) {
        if (feature instanceof HasFeatureDescription) {
            ((HasFeatureDescription)feature).setFeatureDescription(DefaultFeatureFactory.getInstance().buildFeatureDescription(annotation.trim()));
        }
    }

    private static String removeEnd(String annotation, String end) {
        if (annotation.endsWith(end)) {
            return annotation.substring(0, annotation.length() - end.length());
        }
        return annotation;
    }

    public static String consumeMutagenReport(MutagenFeature feature, String value) {
        int index = value.indexOf(": ");
        if (index == -1) {
            return value.substring(0, value.length() - 1);
        }
        String reportString = null;
        reportString = value.substring(index + 2, value.length());
        feature.setMutagenReport(DefaultFeatureFactory.getInstance().buildMutagenReport(reportString));
        return value.substring(0, index).trim();
    }

    public static String consumeVariantReport(VariantFeature feature, String value) {
        int index = value.indexOf(BRACKET_LEFT);
        if (index == -1) {
            return value.substring(0, value.length());
        }
        String reportString = value.substring(index + 1, value.length() - 1);
        reportString = reportString.replaceAll(LINE_END, " ");
        VariantReport aVariantReport = DefaultFeatureFactory.getInstance().buildVariantReport();
        aVariantReport.setValue(reportString);
        feature.setVariantReport(aVariantReport);
        value = value.substring(0, index);
        return value;
    }

    public static String consumeConflictReport(ConflictFeature feature, String value) {
        String[] sp;
        int index = value.indexOf(BRACKET_LEFT);
        if (index == -1) {
            return value.substring(0, value.length() - 1);
        }
        String reportString = value.substring(index + 1, value.length() - 1).trim();
        for (String report : sp = reportString.split(SEMICOLON)) {
            feature.getConflictReports().add(DefaultFeatureFactory.getInstance().buildConflictReport(report.trim()));
        }
        return value.substring(0, index).trim();
    }

    public static String consumeVarSplicFeature(VarSeqFeature feature, String value) {
        String[] isoforms;
        int index = value.indexOf(BRACKET_LEFT);
        if (index == -1) {
            return value.substring(0, value.length());
        }
        value = value.replaceAll("\\(in", BRACKET_LEFT);
        String reportString = value.substring(index + 1, value.length() - 1);
        reportString = reportString.replaceAll(LINE_END, "");
        reportString = reportString.replaceAll(" and ", COMMA);
        reportString = reportString.replaceAll("isoform ", "");
        for (String isoform : isoforms = reportString.split(COMMA)) {
            feature.getVarsplicIsoforms().add(DefaultFeatureFactory.getInstance().buildVarsplicIsoform(isoform.trim()));
        }
        return value.substring(0, index).trim();
    }

    public static String consumeCarbohydFeature(CarbohydFeature feature, String value) {
        if (value.equals("O-linked.")) {
            feature.setCarbohydLinkType(CarbohydLinkType.OXYGEN);
            return "";
        }
        int index = value.indexOf(BRACKET_LEFT);
        if (index == -1) {
            return value;
        }
        String carbohydLinkType = value.substring(0, index - 1);
        int check = carbohydLinkType.indexOf(SEMICOLON);
        if (check != -1) {
            carbohydLinkType = carbohydLinkType.substring(0, check);
            index = check;
        }
        if (carbohydLinkType.equals("N-linked")) {
            feature.setCarbohydLinkType(CarbohydLinkType.NITROGEN);
        } else if (carbohydLinkType.equals("C-linked")) {
            feature.setCarbohydLinkType(CarbohydLinkType.CARBON);
        } else if (carbohydLinkType.equals("O-linked")) {
            feature.setCarbohydLinkType(CarbohydLinkType.OXYGEN);
        } else if (carbohydLinkType.equals("S-linked")) {
            feature.setCarbohydLinkType(CarbohydLinkType.SULFUR);
        }
        value = value.substring(index);
        if (value.length() > 1) {
            int endIndex = value.indexOf(SEMICOLON, 1);
            if (endIndex == -1) {
                endIndex = value.length();
            }
            if (value.charAt(endIndex - 1) == '.') {
                --endIndex;
            }
            String linkedSugar = value.substring(0, endIndex).trim();
            feature.setLinkedSugar(DefaultFeatureFactory.getInstance().buildLinkedSugar(linkedSugar));
            value = value.substring(endIndex);
        }
        if (value.startsWith(SEMICOLON)) {
            value = value.substring(1);
        }
        return value.trim();
    }

    public static void consumeAlternativeSequence(HasAlternativeSequence feature, String value) {
        if (value.equalsIgnoreCase(MISSING) || value.startsWith(MISSING)) {
            return;
        }
        int index = value.indexOf("->");
        String alternativeSequence = value.substring(index + 2).replaceAll(LINE_END, "").replaceAll(" ", "");
        StringTokenizer st = new StringTokenizer(alternativeSequence, ",:or");
        while (st.hasMoreTokens()) {
            FeatureSequence alt = DefaultFeatureFactory.getInstance().buildFeatureSequence(st.nextToken().trim());
            feature.getAlternativeSequences().add(alt);
        }
        FeatureSequence original = DefaultFeatureFactory.getInstance().buildFeatureSequence(value.substring(0, index).trim().replaceAll("\\s*", ""));
        feature.setOriginalSequence(original);
    }

    private static String consumeFeatureId(HasFeatureId feature, String annotation) {
        int index = annotation.indexOf(FT_ID);
        if (index == -1) {
            return annotation;
        }
        String id = annotation.substring(index + 6, annotation.length() - 1);
        feature.setFeatureId(DefaultFeatureFactory.getInstance().buildFeatureId(id));
        String s = annotation.substring(0, index);
        return s.trim();
    }

    public static String getStringConflictReports(ConflictFeature feature) {
        StringBuilder temp = new StringBuilder();
        boolean first = true;
        for (ConflictReport c : feature.getConflictReports()) {
            if (first) {
                first = false;
            } else {
                temp.append("; ");
            }
            temp.append(c.getValue());
        }
        return temp.toString();
    }

    public static String getStringIsoformsVarSplicFeature(VarSeqFeature feature) {
        StringBuilder temp = new StringBuilder();
        int numberReports = feature.getVarsplicIsoforms().size();
        if (numberReports == 0) {
            return "";
        }
        int count = 0;
        for (VarsplicIsoform isoform : feature.getVarsplicIsoforms()) {
            if (count == 0) {
                temp.append("in ");
            } else if (count < numberReports - 1) {
                temp.append(", ");
            } else {
                temp.append(" and ");
            }
            temp.append("isoform ");
            temp.append(isoform.getValue());
            ++count;
        }
        return temp.toString();
    }

    public static void extractSequenceLocation(String fullSequence, HasAlternativeSequence conflictFeature) {
        try {
            String missingSequence = fullSequence.substring(conflictFeature.getFeatureLocation().getStart() - 1, conflictFeature.getFeatureLocation().getEnd());
            FeatureSequence anOriginalSequence = DefaultFeatureFactory.getInstance().buildFeatureSequence(missingSequence);
            conflictFeature.setOriginalSequence(anOriginalSequence);
        }
        catch (StringIndexOutOfBoundsException e) {
            LOGGER.error("Wrong original sequence location");
        }
    }

    public static List<Integer> getReferencesForConflictFeature(ConflictFeature feature) {
        ArrayList<Integer> refs = new ArrayList<Integer>();
        List<ConflictReport> conflictReports = feature.getConflictReports();
        for (ConflictReport conflictReport : conflictReports) {
            String report = conflictReport.getValue();
            if (report.indexOf("except") >= 0) continue;
            String[] tokens = report.split(",| ");
            for (int i = 0; i < tokens.length; ++i) {
                String token = tokens[i];
                if (!token.matches("\\d+")) continue;
                refs.add(Integer.decode(token));
            }
        }
        return refs;
    }
}

