/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.organelles;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.GeneEncodingType;
import uk.ac.ebi.kraken.interfaces.uniprot.Organelle;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.factories.DefaultEvidenceFactory;
import uk.ac.ebi.kraken.util.NoNullElementsList;

public class OrganelleImpl
implements Organelle {
    private String value;
    private GeneEncodingType type;
    private List<EvidenceId> evidenceIds;
    private long id;

    public OrganelleImpl() {
        this.value = "";
        this.type = GeneEncodingType.UNKOWN;
    }

    public OrganelleImpl(Organelle copy) {
        this.type = copy.getType();
        this.value = copy.getValue();
        this.evidenceIds = new NoNullElementsList<EvidenceId>(new ArrayList());
        for (EvidenceId evidenceId : copy.getEvidenceIds()) {
            this.evidenceIds.add(DefaultEvidenceFactory.getInstance().buildEvidenceId(evidenceId.getValue()));
        }
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    @Override
    public void setType(GeneEncodingType type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.type = type;
    }

    @Override
    public GeneEncodingType getType() {
        return this.type;
    }

    @Override
    public boolean hasValue() {
        return this.value != null && !this.value.trim().isEmpty();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public List<EvidenceId> getEvidenceIds() {
        if (this.evidenceIds == null) {
            this.evidenceIds = new ArrayList<EvidenceId>();
        }
        return this.evidenceIds;
    }

    @Override
    public void setEvidenceIds(List<EvidenceId> evidenceIds) {
        this.evidenceIds = evidenceIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrganelleImpl organelle = (OrganelleImpl)o;
        if (this.evidenceIds != null && !this.evidenceIds.isEmpty() ? !this.evidenceIds.equals(organelle.evidenceIds) : organelle.evidenceIds != null && !organelle.evidenceIds.isEmpty()) {
            return false;
        }
        if (this.type != organelle.type) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(organelle.value) : organelle.value != null);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 29 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 29 * result + (this.evidenceIds != null && !this.evidenceIds.isEmpty() ? this.evidenceIds.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this.type) {
            case HYDROGENOSOME: 
            case MITOCHONDRION: 
            case NUCLEOMORPH: 
            case PLASTID: {
                sb.append(this.getType().getValue());
                break;
            }
            case PLASMID: {
                sb.append(this.getType().getValue());
                if (this.getValue() == null || this.getValue().equals("")) break;
                sb.append(" ");
                sb.append(this.getValue());
                break;
            }
            case APICOPLAST_PLASTID: 
            case CHLOROPLAST_PLASTID: 
            case CYANELLE_PLASTID: 
            case NON_PHOTOSYNTHETIC_PLASTID: 
            case CHROMATOPHORE_PLASTID: {
                sb.append("Plastid; ");
                sb.append(this.getType().getValue());
                break;
            }
        }
        return sb.toString();
    }
}

