/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.internalsection;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.internalsection.InternalLine;
import uk.ac.ebi.kraken.interfaces.uniprot.internalsection.InternalSection;
import uk.ac.ebi.kraken.interfaces.uniprot.internalsection.SourceLine;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;

public class InternalSectionImpl
implements InternalSection {
    private List<InternalLine> internalLines = new ArrayList<InternalLine>();
    private List<SourceLine> sourceLines = new ArrayList<SourceLine>();

    public InternalSectionImpl(List<InternalLine> internalLines, List<SourceLine> sourceLines) {
        this.sourceLines = sourceLines;
        this.internalLines = internalLines;
    }

    public InternalSectionImpl(InternalSection copy) {
        for (InternalLine internalLine : copy.getInternalLines()) {
            InternalLine internalLine2 = DefaultUniProtFactory.getInstance().buildInternalLine();
            internalLine2.setInternalLineType(internalLine.getInternalLineType());
            internalLine2.setValue(new String(internalLine.getValue()));
            this.internalLines.add(internalLine2);
        }
        for (SourceLine sourceLine : copy.getSourceLines()) {
            SourceLine sline = DefaultUniProtFactory.getInstance().buildSourceLine(sourceLine.getValue());
            this.sourceLines.add(sline);
        }
    }

    public InternalSectionImpl() {
    }

    @Override
    public List<InternalLine> getInternalLines() {
        return this.internalLines;
    }

    @Override
    public void setInternalLines(List<InternalLine> internalLine) {
        if (internalLine == null) {
            throw new IllegalArgumentException();
        }
        this.internalLines = internalLine;
    }

    @Override
    public List<SourceLine> getSourceLines() {
        return this.sourceLines;
    }

    @Override
    public void setSourceLines(List<SourceLine> sourceLines) {
        if (sourceLines == null) {
            throw new IllegalArgumentException();
        }
        this.sourceLines = sourceLines;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalSectionImpl that = (InternalSectionImpl)o;
        if (!this.internalLines.equals(that.internalLines)) {
            return false;
        }
        return this.sourceLines.equals(that.sourceLines);
    }

    public int hashCode() {
        int result = this.internalLines != null ? this.internalLines.hashCode() : 0;
        result = 31 * result + (this.sourceLines != null ? this.sourceLines.hashCode() : 0);
        return result;
    }
}

