/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PAGEDataComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PAGEDataMolecularWeight;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PAGEDataPl;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.model.uniprot.comments.MiscellaneousCommentImpl;

public class PAGEDataCommentImpl
extends MiscellaneousCommentImpl
implements PAGEDataComment {
    private PAGEDataPl pl;
    private PAGEDataMolecularWeight molecularWeight;

    public PAGEDataCommentImpl() {
        this.setCommentType(CommentType.PAGE);
        this.pl = DefaultCommentFactory.getInstance().buildPAGEDataPl();
        this.molecularWeight = DefaultCommentFactory.getInstance().buildPAGEDataMolecularWeight();
    }

    public PAGEDataCommentImpl(PAGEDataComment copy) {
        super(copy);
        this.setCommentType(CommentType.PAGE);
    }

    @Override
    public PAGEDataPl getPl() {
        return this.pl;
    }

    @Override
    public void setPl(PAGEDataPl pl) {
        if (pl == null) {
            throw new IllegalArgumentException("That value is null");
        }
        this.pl = pl;
    }

    @Override
    public PAGEDataMolecularWeight getMolecularWeight() {
        return this.molecularWeight;
    }

    @Override
    public void setMolecularWeight(PAGEDataMolecularWeight molecularWeight) {
        if (molecularWeight == null) {
            throw new IllegalArgumentException("That value is null");
        }
        this.molecularWeight = molecularWeight;
    }

    @Override
    public String getValue() {
        return "On the 2D-gel the determined pI of this protein is: " + this.pl + ", its MW is: " + this.molecularWeight + " kDa.";
    }
}

