/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Cofactor;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CofactorCommentStructured;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CofactorNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.uniprot.CommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.CofactorImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.CofactorNoteImpl;

public class CofactorCommentStructuredImpl
extends CommentImpl
implements CofactorCommentStructured,
PersistentObject {
    private static final long serialVersionUID = 1L;
    private CofactorNote note;
    private List<Cofactor> cofactors;

    public CofactorCommentStructuredImpl() {
        this.setCommentType(CommentType.COFACTOR);
        this.note = new CofactorNoteImpl();
        this.cofactors = new ArrayList<Cofactor>();
    }

    public CofactorCommentStructuredImpl(CofactorCommentStructured copy) {
        super(copy);
        this.setCommentType(CommentType.COFACTOR);
        if (copy.getNote() != null) {
            this.note = new CofactorNoteImpl(copy.getNote());
        }
        this.cofactors = new ArrayList<Cofactor>();
        for (Cofactor cofactor : copy.getCofactors()) {
            this.cofactors.add(new CofactorImpl(cofactor));
        }
    }

    @Override
    public List<Cofactor> getCofactors() {
        return this.cofactors;
    }

    @Override
    public void setCofactors(List<Cofactor> cofactors) {
        if (cofactors == null) {
            throw new IllegalArgumentException();
        }
        this.cofactors = cofactors;
    }

    @Override
    public CofactorNote getNote() {
        return this.note;
    }

    @Override
    public void setNote(CofactorNote note) {
        this.note = note;
    }

    @Override
    public Collection<EvidenceId> collectEvidences() {
        HashSet<EvidenceId> evidences = new HashSet<EvidenceId>();
        this.note.getTexts().stream().flatMap(val -> val.getEvidenceIds().stream()).forEach(val -> evidences.add((EvidenceId)val));
        this.cofactors.forEach(val -> evidences.addAll(val.getEvidenceIds()));
        return evidences;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.cofactors == null ? 0 : this.cofactors.hashCode());
        result = 31 * result + (this.note == null ? 0 : this.note.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CofactorCommentStructuredImpl other = (CofactorCommentStructuredImpl)obj;
        if (this.cofactors == null ? other.cofactors != null : !this.cofactors.equals(other.cofactors)) {
            return false;
        }
        return !(this.note == null ? other.note != null : !this.note.equals(other.note));
    }
}

