/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Absorption;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.BioPhysicoChemicalPropertiesComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.KineticParameters;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MaximumVelocity;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MichaelisConstant;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PHDependence;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RedoxPotential;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.TemperatureDependence;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.model.uniprot.CommentImpl;

public class BioPhysicoChemicalPropertiesCommentImpl
extends CommentImpl
implements BioPhysicoChemicalPropertiesComment {
    private Absorption absorption;
    private PHDependence phDependence;
    private RedoxPotential redoxPotential;
    private TemperatureDependence temperatureDependence;
    private KineticParameters kineticParameters;

    public BioPhysicoChemicalPropertiesCommentImpl() {
        this.setCommentType(CommentType.BIOPHYSICOCHEMICAL_PROPERTIES);
        this.absorption = DefaultCommentFactory.getInstance().buildAbsorption();
        this.redoxPotential = DefaultCommentFactory.getInstance().buildRedoxPotential();
        this.temperatureDependence = DefaultCommentFactory.getInstance().buildTemperatureDependence();
        this.kineticParameters = DefaultCommentFactory.getInstance().buildKineticParameters();
        this.phDependence = DefaultCommentFactory.getInstance().buildPHDependence();
    }

    public BioPhysicoChemicalPropertiesCommentImpl(BioPhysicoChemicalPropertiesComment copy) {
        this();
        this.absorption = DefaultCommentFactory.getInstance().buildAbsorption();
        this.redoxPotential = DefaultCommentFactory.getInstance().buildRedoxPotential();
        this.temperatureDependence = DefaultCommentFactory.getInstance().buildTemperatureDependence();
        this.kineticParameters = DefaultCommentFactory.getInstance().buildKineticParameters();
        this.phDependence = DefaultCommentFactory.getInstance().buildPHDependence();
        if (copy.getPHDependence() != null) {
            this.phDependence = DefaultCommentFactory.getInstance().buildPHDependence(copy.getPHDependence());
        }
        if (copy.getAbsorption() != null) {
            this.absorption = DefaultCommentFactory.getInstance().buildAbsorption(copy.getAbsorption());
        }
        if (copy.getRedoxPotential() != null) {
            this.redoxPotential = DefaultCommentFactory.getInstance().buildRedoxPotential(copy.getRedoxPotential());
        }
        if (copy.getTemperatureDependence() != null) {
            this.temperatureDependence = DefaultCommentFactory.getInstance().buildTemperatureDependence(copy.getTemperatureDependence());
        }
        if (copy.getKineticParameters() != null) {
            this.kineticParameters = DefaultCommentFactory.getInstance().buildKineticParameters(copy.getKineticParameters());
        }
    }

    @Override
    public Absorption getAbsorption() {
        return this.absorption;
    }

    @Override
    public void setAbsorption(Absorption absorption) {
        this.absorption = absorption;
    }

    @Override
    public boolean hasAbsorptionProperty() {
        return this.absorption != null && !this.absorption.equals(DefaultCommentFactory.getInstance().buildAbsorption());
    }

    @Override
    public PHDependence getPHDependence() {
        return this.phDependence;
    }

    @Override
    public void setPHDepencence(PHDependence phDependence) {
        this.phDependence = phDependence;
    }

    @Override
    public boolean hasPHDependenceProperty() {
        return this.phDependence != null && !this.phDependence.equals(DefaultCommentFactory.getInstance().buildPHDependence());
    }

    @Override
    public RedoxPotential getRedoxPotential() {
        return this.redoxPotential;
    }

    @Override
    public boolean hasRedoxPotentialProperty() {
        return this.redoxPotential != null && !this.redoxPotential.equals(DefaultCommentFactory.getInstance().buildRedoxPotential());
    }

    @Override
    public void setRedoxPotential(RedoxPotential redoxPotential) {
        this.redoxPotential = redoxPotential;
    }

    @Override
    public TemperatureDependence getTemperatureDependence() {
        return this.temperatureDependence;
    }

    @Override
    public boolean hasTemperatureDependenceProperty() {
        return this.temperatureDependence != null && !this.temperatureDependence.equals(DefaultCommentFactory.getInstance().buildTemperatureDependence());
    }

    @Override
    public void setTemperatureDependence(TemperatureDependence temperatureDependence) {
        this.temperatureDependence = temperatureDependence;
    }

    @Override
    public void setKineticParameters(KineticParameters kineticParameters) {
        this.kineticParameters = kineticParameters;
    }

    @Override
    public KineticParameters getKineticParameters() {
        return this.kineticParameters;
    }

    @Override
    public boolean hasKineticParametersProperty() {
        return this.kineticParameters != null && !this.kineticParameters.equals(DefaultCommentFactory.getInstance().buildKineticParameters());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.absorption == null ? 0 : this.absorption.hashCode());
        result = 31 * result + (this.kineticParameters == null ? 0 : this.kineticParameters.hashCode());
        result = 31 * result + (this.phDependence == null ? 0 : this.phDependence.hashCode());
        result = 31 * result + (this.redoxPotential == null ? 0 : this.redoxPotential.hashCode());
        result = 31 * result + (this.temperatureDependence == null ? 0 : this.temperatureDependence.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BioPhysicoChemicalPropertiesCommentImpl other = (BioPhysicoChemicalPropertiesCommentImpl)obj;
        if (this.absorption == null ? other.absorption != null : !this.absorption.equals(other.absorption)) {
            return false;
        }
        if (this.kineticParameters == null ? other.kineticParameters != null : !this.kineticParameters.equals(other.kineticParameters)) {
            return false;
        }
        if (this.phDependence == null ? other.phDependence != null : !this.phDependence.equals(other.phDependence)) {
            return false;
        }
        if (this.redoxPotential == null ? other.redoxPotential != null : !this.redoxPotential.equals(other.redoxPotential)) {
            return false;
        }
        return !(this.temperatureDependence == null ? other.temperatureDependence != null : !this.temperatureDependence.equals(other.temperatureDependence));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("");
        sb.append("\n");
        BioPhysicoChemicalPropertiesCommentImpl bioPCPropComment = this;
        sb.append("CC   -!- ");
        sb.append(bioPCPropComment.getCommentType().toDisplayName());
        String molecule = this.getMolecule();
        if (molecule != null && !molecule.isEmpty()) {
            sb.append(": [").append(molecule).append("]");
        }
        sb.append(":");
        if (bioPCPropComment.hasAbsorptionProperty()) {
            sb.append("\nCC       Absorption:\n");
            Absorption absorption = bioPCPropComment.getAbsorption();
            sb.append("CC         Abs(max)=");
            if (absorption.isApproximation()) {
                sb.append("~");
            }
            sb.append(absorption.getMax());
            sb.append(" nm;");
            if (absorption.hasNote()) {
                sb.append("\nCC         Note=").append(absorption.getNote().toString()).append(";");
            }
        }
        if (bioPCPropComment.hasKineticParametersProperty()) {
            sb.append("\nCC       Kinetic parameters:");
            if (null != bioPCPropComment.getKineticParameters().getMichaelisConstants()) {
                List<MichaelisConstant> michaelisConstants = bioPCPropComment.getKineticParameters().getMichaelisConstants();
                System.err.println("michaelisConstants.size() = " + michaelisConstants.size());
                for (MichaelisConstant michaelisConstant : michaelisConstants) {
                    StringBuilder temp = sb;
                    temp.append("\nCC         KM=");
                    temp.append(michaelisConstant.getConstant());
                    temp.append(" ");
                    temp.append(michaelisConstant.getUnit().toDisplayNameString());
                    temp.append(" for ");
                    temp.append(michaelisConstant.getSubstrate().getValue());
                    temp.append(";");
                    sb.append("\n");
                }
            }
            if (null != bioPCPropComment.getKineticParameters().getMaximumVelocities() && !bioPCPropComment.getKineticParameters().getMaximumVelocities().isEmpty()) {
                List<MaximumVelocity> maximumVelocities = bioPCPropComment.getKineticParameters().getMaximumVelocities();
                for (MaximumVelocity maximumVelocity : maximumVelocities) {
                    sb.append("CC         Vmax=" + maximumVelocity.getVelocity() + " " + maximumVelocity.getMaxVelocityUnit().getValue() + " " + maximumVelocity.getEnzyme().getValue() + ";");
                    sb.append("\n");
                }
            }
            if (bioPCPropComment.getKineticParameters().hasKineticParameterNote()) {
                String temp = "CC         Note=" + bioPCPropComment.getKineticParameters().getNote().toString() + ";";
                sb.append("\n");
            }
        }
        if (bioPCPropComment.hasPHDependenceProperty()) {
            sb.append("\nCC       pH dependence:\nCC         ");
            sb.append(bioPCPropComment.getPHDependence().toString());
            sb.append(";");
        }
        if (bioPCPropComment.hasRedoxPotentialProperty()) {
            sb.append("\nCC       Redox potential:\nCC         ");
            sb.append(bioPCPropComment.getRedoxPotential().toString());
            sb.append(";");
        }
        if (bioPCPropComment.hasTemperatureDependenceProperty()) {
            sb.append("\nCC       Temperature dependence:\n");
            sb.append("CC         " + bioPCPropComment.getTemperatureDependence().toString() + ";");
        }
        return sb.toString();
    }

    @Override
    public Collection<EvidenceId> collectEvidences() {
        HashSet<EvidenceId> evidences = new HashSet<EvidenceId>();
        evidences.addAll(this.absorption.getEvidenceIds());
        this.kineticParameters.getMaximumVelocities().forEach(val -> evidences.addAll(val.getEvidenceIds()));
        this.kineticParameters.getMichaelisConstants().forEach(val -> evidences.addAll(val.getEvidenceIds()));
        this.kineticParameters.getNote().getTexts().forEach(val -> evidences.addAll(val.getEvidenceIds()));
        this.phDependence.getTexts().forEach(val -> evidences.addAll(val.getEvidenceIds()));
        this.redoxPotential.getTexts().forEach(val -> evidences.addAll(val.getEvidenceIds()));
        this.temperatureDependence.getTexts().forEach(val -> evidences.addAll(val.getEvidenceIds()));
        return evidences;
    }
}

