/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.serialize;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefDatabase;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefDatabaseType;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefEntry;
import uk.ac.ebi.kraken.interfaces.uniref.member.UniProtAccession;
import uk.ac.ebi.kraken.interfaces.uniref.member.UniRefMember;
import uk.ac.ebi.kraken.interfaces.uniref.member.UniRefRepresentativeMember;
import uk.ac.ebi.kraken.model.factories.DefaultUniRefFactory;
import uk.ac.ebi.kraken.model.serialize.DefaultCommonSerializer;
import uk.ac.ebi.kraken.model.serialize.UniRefEntryImplSerializer;

public class DefaultUniRefEntryImplSerializer
extends DefaultCommonSerializer
implements UniRefEntryImplSerializer {
    @Override
    public void writeObject(UniRefEntry entry, ObjectOutput out) throws IOException {
        this.writeId(out, entry);
        out.writeLong(entry.getUpdate().getTime());
        out.writeObject(entry.getUniRefEntryId().getValue());
        out.writeLong(entry.getUniRefDatabase().getReleaseDate().getTime());
        out.writeObject(entry.getUniRefDatabase().getType().name());
        out.writeObject(entry.getUniRefDatabase().getUniRefVersion().getValue());
        out.writeBoolean(entry.getRepresentativeMember().isSeed());
        out.writeInt(entry.getRepresentativeMember().getLength());
        out.writeObject(entry.getRepresentativeMember().getMemberId().getValue());
        out.writeObject(entry.getRepresentativeMember().getNCBITaxonomy().getValue());
        out.writeInt(entry.getRepresentativeMember().getOverlapRegion().getEnd());
        out.writeInt(entry.getRepresentativeMember().getOverlapRegion().getStart());
        out.writeObject(entry.getRepresentativeMember().getOverlapRegion().getValue());
        out.writeObject(entry.getRepresentativeMember().getProteinName().getValue());
        this.writeSequence(out, entry.getRepresentativeMember().getSequence());
        out.writeObject(entry.getRepresentativeMember().getSourceOrganism().getValue());
        out.writeObject(entry.getRepresentativeMember().getType().getValue());
        out.writeObject(entry.getRepresentativeMember().getUniParcAccession().getValue());
        this.writeRepMemberAccession(out, entry);
        out.writeObject(entry.getRepresentativeMember().getUniRef100EntryId().getValue());
        out.writeObject(entry.getRepresentativeMember().getUniRef90EntryId().getValue());
        out.writeObject(entry.getRepresentativeMember().getUniRef50EntryId().getValue());
        out.writeObject(entry.getName().getValue());
        this.writeMembers(out, entry);
    }

    @Override
    public void readObject(UniRefEntry entry, ObjectInput in) throws IOException, ClassNotFoundException {
        DefaultUniRefFactory factory = DefaultUniRefFactory.getInstance();
        this.readId(in, entry);
        entry.setUpdate(new Date(in.readLong()));
        entry.setUniRefEntryId(factory.buildUniRefEntryId((String)in.readObject()));
        UniRefDatabase db = factory.buildUniRefDatabase();
        db.setReleaseDate(new Date(in.readLong()));
        db.setType(UniRefDatabaseType.typeOf((String)in.readObject()));
        db.setVersion(factory.buildUniRefDatabaseVersion((String)in.readObject()));
        entry.setUniRefDatabase(db);
        UniRefRepresentativeMember repMember = factory.buildUniRefRepresentativeMember();
        repMember.setSeed(in.readBoolean());
        repMember.setLength(in.readInt());
        repMember.getMemberId().setValue((String)in.readObject());
        repMember.getNCBITaxonomy().setValue((String)in.readObject());
        int end = in.readInt();
        int start = in.readInt();
        repMember.getOverlapRegion().setPosition(start, end);
        repMember.getOverlapRegion().setValue((String)in.readObject());
        repMember.getProteinName().setValue((String)in.readObject());
        this.readSequence(in, repMember.getSequence());
        repMember.getSourceOrganism().setValue((String)in.readObject());
        repMember.getType().setValue((String)in.readObject());
        repMember.getUniParcAccession().setValue((String)in.readObject());
        this.readRepMemberAccession(in, repMember);
        repMember.getUniRef100EntryId().setValue((String)in.readObject());
        repMember.getUniRef90EntryId().setValue((String)in.readObject());
        repMember.getUniRef50EntryId().setValue((String)in.readObject());
        entry.setRepresentativeMember(repMember);
        entry.getName().setValue((String)in.readObject());
        this.readMembers(in, entry);
    }

    public void writeRepMemberAccession(ObjectOutput out, UniRefEntry entry) throws IOException {
        out.writeInt(entry.getRepresentativeMember().getUniProtAccessions().size());
        for (UniProtAccession ac : entry.getRepresentativeMember().getUniProtAccessions()) {
            out.writeObject(ac.getValue());
        }
    }

    public void readRepMemberAccession(ObjectInput in, UniRefRepresentativeMember entry) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int iii = 0; iii < size; ++iii) {
            String ac = (String)in.readObject();
            entry.getUniProtAccessions().add(DefaultUniRefFactory.getInstance().buildMemberUniProtAccession(ac));
        }
    }

    public void readMembers(ObjectInput in, UniRefEntry entry) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        DefaultUniRefFactory factory = DefaultUniRefFactory.getInstance();
        for (int iii = 0; iii < size; ++iii) {
            UniRefMember member = factory.buildUniRefMember();
            member.setSeed(in.readBoolean());
            member.setLength(in.readInt());
            member.getMemberId().setValue((String)in.readObject());
            member.getNCBITaxonomy().setValue((String)in.readObject());
            int end = in.readInt();
            int start = in.readInt();
            member.getOverlapRegion().setPosition(start, end);
            member.getOverlapRegion().setValue((String)in.readObject());
            member.getProteinName().setValue((String)in.readObject());
            member.getSourceOrganism().setValue((String)in.readObject());
            member.getType().setValue((String)in.readObject());
            member.getUniParcAccession().setValue((String)in.readObject());
            int asize = in.readInt();
            for (int jjj = 0; jjj < asize; ++jjj) {
                String ac = (String)in.readObject();
                member.getUniProtAccessions().add(factory.buildMemberUniProtAccession(ac));
            }
            member.getUniRef100EntryId().setValue((String)in.readObject());
            member.getUniRef90EntryId().setValue((String)in.readObject());
            member.getUniRef50EntryId().setValue((String)in.readObject());
            entry.getMembers().add(member);
        }
    }

    public void writeMembers(ObjectOutput out, UniRefEntry entry) throws IOException {
        out.writeInt(entry.getMembers().size());
        for (UniRefMember member : entry.getMembers()) {
            out.writeBoolean(member.isSeed());
            out.writeInt(member.getLength());
            out.writeObject(member.getMemberId().getValue());
            out.writeObject(member.getNCBITaxonomy().getValue());
            out.writeInt(member.getOverlapRegion().getEnd());
            out.writeInt(member.getOverlapRegion().getStart());
            out.writeObject(member.getOverlapRegion().getValue());
            out.writeObject(member.getProteinName().getValue());
            out.writeObject(member.getSourceOrganism().getValue());
            out.writeObject(member.getType().getValue());
            out.writeObject(member.getUniParcAccession().getValue());
            out.writeInt(member.getUniProtAccessions().size());
            for (UniProtAccession ac : member.getUniProtAccessions()) {
                out.writeObject(ac.getValue());
            }
            out.writeObject(member.getUniRef100EntryId().getValue());
            out.writeObject(member.getUniRef90EntryId().getValue());
            out.writeObject(member.getUniRef50EntryId().getValue());
        }
    }
}

