/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.interfaces.uniprot.comments;

public enum CommentType {
    FUNCTION("FUNCTION", "function"),
    CATALYTIC_ACTIVITY("CATALYTIC ACTIVITY", "catalytic activity"),
    COFACTOR("COFACTOR", "cofactor"),
    ACTIVITY_REGULATION("ACTIVITY REGULATION", "activity regulation"),
    BIOPHYSICOCHEMICAL_PROPERTIES("BIOPHYSICOCHEMICAL PROPERTIES", "biophysicochemical properties"),
    PATHWAY("PATHWAY", "pathway"),
    SUBUNIT("SUBUNIT", "subunit"),
    INTERACTION("INTERACTION", "interaction"),
    SUBCELLULAR_LOCATION("SUBCELLULAR LOCATION", "subcellular location"),
    ALTERNATIVE_PRODUCTS("ALTERNATIVE PRODUCTS", "alternative products"),
    TISSUE_SPECIFICITY("TISSUE SPECIFICITY", "tissue specificity"),
    DEVELOPMENTAL_STAGE("DEVELOPMENTAL STAGE", "developmental stage"),
    INDUCTION("INDUCTION", "induction"),
    DOMAIN("DOMAIN", "domain"),
    PTM("PTM", "PTM"),
    RNA_EDITING("RNA EDITING", "RNA editing"),
    MASS_SPECTROMETRY("MASS SPECTROMETRY", "mass spectrometry"),
    POLYMORPHISM("POLYMORPHISM", "polymorphism"),
    DISEASE("DISEASE", "disease"),
    DISRUPTION_PHENOTYPE("DISRUPTION PHENOTYPE", "disruption phenotype"),
    ALLERGEN("ALLERGEN", "allergen"),
    TOXIC_DOSE("TOXIC DOSE", "toxic dose"),
    BIOTECHNOLOGY("BIOTECHNOLOGY", "biotechnology"),
    PHARMACEUTICAL("PHARMACEUTICAL", "pharmaceutical"),
    MISCELLANEOUS("MISCELLANEOUS", "miscellaneous"),
    SIMILARITY("SIMILARITY", "similarity"),
    CAUTION("CAUTION", "caution"),
    SEQUENCE_CAUTION("SEQUENCE CAUTION", "sequence caution"),
    WEBRESOURCE("WEB RESOURCE", "online information"),
    PAGE("PAGE", "page"),
    UNKNOWN("UNKOWN", "unknown");

    private final String xmlDisplayValue;
    private String value;

    private CommentType(String value, String xmlDisplayValue) {
        this.value = value;
        this.xmlDisplayValue = xmlDisplayValue;
    }

    public String toDisplayName() {
        return this.value;
    }

    public String toXmlDisplayName() {
        return this.xmlDisplayValue;
    }

    public static CommentType dbTypeOf(String value) {
        for (CommentType commentType : CommentType.values()) {
            if (!commentType.toString().equalsIgnoreCase(value)) continue;
            return commentType;
        }
        throw new IllegalArgumentException("The comment type: " + value + " doesn't exist");
    }

    public static CommentType typeOf(String value) {
        for (CommentType commentType : CommentType.values()) {
            if (!commentType.toDisplayName().trim().equalsIgnoreCase(value.trim())) continue;
            return commentType;
        }
        throw new IllegalArgumentException("The comment type: " + value + " doesn't exist");
    }
}

