/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl.ft;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.line.FFLineWrapper;
import uk.ac.ebi.kraken.ffwriter.line.impl.ft.FTLineBuilderHelper;
import uk.ac.ebi.kraken.ffwriter.line.impl.ft.SimpleFeatureLineBuilder;
import uk.ac.ebi.kraken.interfaces.uniprot.features.VarSeqFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.VarsplicIsoform;

public class VarSeqFeatureBuilder
extends SimpleFeatureLineBuilder<VarSeqFeature> {
    @Override
    protected List<String> buildFtNoteLines(VarSeqFeature f, boolean includeFFMarkings) {
        ArrayList<String> lines = new ArrayList<String>();
        List<String> lines2 = FTLineBuilderHelper.buildNote(f, includeFFMarkings);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lines2.size(); ++i) {
            if (i == lines2.size() - 1) {
                sb = new StringBuilder(lines2.get(i));
                continue;
            }
            lines.add(lines2.get(i));
        }
        if (!f.getVarsplicIsoforms().isEmpty()) {
            sb.append(" (");
            sb.append(FTLineBuilderHelper.replaceDoubleQuoteWithDoubleDoubleQuote(this.getStringIsoformsVarSplicFeature(f)));
            sb.append(")");
        }
        sb.append("\"");
        String[] seps = new String[]{" ", "-"};
        if (includeFFMarkings) {
            lines.addAll(FFLineWrapper.buildLines(sb.toString(), seps, "FT                   ", 80));
        } else {
            lines.add(sb.toString());
        }
        return lines;
    }

    private String getStringIsoformsVarSplicFeature(VarSeqFeature feature) {
        StringBuilder temp = new StringBuilder();
        int numberReports = feature.getVarsplicIsoforms().size();
        if (numberReports == 0) {
            return "";
        }
        int count = 0;
        for (VarsplicIsoform isoform : feature.getVarsplicIsoforms()) {
            if (count == 0) {
                temp.append("in ");
            } else if (count < numberReports - 1) {
                temp.append(", ");
            } else {
                temp.append(" and ");
            }
            temp.append("isoform ");
            temp.append(isoform.getValue());
            ++count;
        }
        return temp.toString();
    }
}

