/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl.cc;

import com.google.common.base.Strings;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import uk.ac.ebi.kraken.ffwriter.line.FFLineWrapper;
import uk.ac.ebi.kraken.ffwriter.line.impl.cc.CCLineBuilderAbstr;
import uk.ac.ebi.kraken.interfaces.uniprot.HasEvidences;
import uk.ac.ebi.kraken.interfaces.uniprot.HasFreeText;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Absorption;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.BioPhysicoChemicalPropertiesComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.KineticParameters;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MaximumVelocity;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MichaelisConstant;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PHDependence;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RedoxPotential;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.TemperatureDependence;

public class BioPhyChemCCLineBuilder
extends CCLineBuilderAbstr<BioPhysicoChemicalPropertiesComment> {
    private static final String TEMPERATURE_DEPENDENCE = "Temperature dependence:";
    private static final String REDOX_POTENTIAL = "Redox potential:";
    private static final String P_H_DEPENDENCE = "pH dependence:";
    private static final String VMAX = "Vmax=";
    private static final String FOR = " for ";
    private static final String KM2 = "KM=";
    private static final String KINETIC_PARAMETERS = "Kinetic parameters:";
    private static final String NM = " nm";
    private static final String ABS_MAX = "Abs(max)=";
    private static final String ABSORPTION2 = "Absorption:";

    @Override
    protected List<String> buildCommentLines(BioPhysicoChemicalPropertiesComment comment, boolean includeFlatFileMarkings, boolean showEvidence) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(this.buildStartWithMolecule(comment, includeFlatFileMarkings));
        if (comment.hasAbsorptionProperty()) {
            lines.addAll(this.buildAbsorptionLine(comment.getAbsorption(), includeFlatFileMarkings, showEvidence));
        }
        if (comment.hasKineticParametersProperty()) {
            lines.addAll(this.buildKineticLine(comment.getKineticParameters(), includeFlatFileMarkings, showEvidence));
        }
        if (comment.hasPHDependenceProperty()) {
            lines.addAll(this.buildPHDepLine(comment.getPHDependence(), includeFlatFileMarkings, showEvidence));
        }
        if (comment.hasRedoxPotentialProperty()) {
            lines.addAll(this.buildRedoxLine(comment.getRedoxPotential(), includeFlatFileMarkings, showEvidence));
        }
        if (comment.hasTemperatureDependenceProperty()) {
            lines.addAll(this.buildTempLine(comment.getTemperatureDependence(), includeFlatFileMarkings, showEvidence));
        }
        if (!showEvidence) {
            return lines;
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<String> lines2 = new ArrayList<String>();
        for (int i = 0; i < lines.size(); ++i) {
            if (i == lines.size() - 1) {
                sb.append((String)lines.get(i));
                continue;
            }
            lines2.add((String)lines.get(i));
        }
        sb = this.addEvidences(sb, comment, showEvidence);
        if (includeFlatFileMarkings) {
            List<String> lls = FFLineWrapper.buildLines(sb, " ", "CC         ");
            lines2.addAll(lls);
        } else {
            lines2.add(sb.toString());
        }
        return lines2;
    }

    private StringBuilder buildStart(String name, boolean includeFlatFileMarkings) {
        StringBuilder start = new StringBuilder();
        if (includeFlatFileMarkings) {
            start.append(this.linePrefix);
        }
        start.append(name);
        return start;
    }

    private List<String> buildAbsorptionLine(Absorption absorption, boolean includeFlatFileMarkings, boolean showEvidence) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(this.buildStart(ABSORPTION2, includeFlatFileMarkings).toString());
        if (includeFlatFileMarkings) {
            sb.append("CC         ");
        }
        sb.append(ABS_MAX);
        if (absorption.isApproximation()) {
            sb.append("~");
        }
        sb.append(absorption.getMax());
        sb.append(NM);
        lines.addAll(this.addEvidences(sb, absorption, includeFlatFileMarkings, showEvidence, ";", ";"));
        if (absorption.hasNote()) {
            lines.addAll(this.buildNote(absorption.getNote(), includeFlatFileMarkings, showEvidence));
        }
        return lines;
    }

    private List<String> buildNote(HasFreeText note, boolean includeFlatFileMarkings, boolean showEvidence) {
        StringBuilder noteBuilder = new StringBuilder();
        if (includeFlatFileMarkings) {
            noteBuilder.append("CC         ");
        }
        noteBuilder.append("Note=");
        String freeTextStr = this.buildFreeText(note, showEvidence, ".", ";");
        noteBuilder.append(freeTextStr);
        if (includeFlatFileMarkings) {
            return FFLineWrapper.buildLines(noteBuilder, " ", "CC         ");
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(noteBuilder.toString());
        return lines;
    }

    private List<String> buildKineticLine(KineticParameters kps, boolean includeFlatFileMarkings, boolean showEvidence) {
        String val2;
        String val;
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(this.buildStart(KINETIC_PARAMETERS, includeFlatFileMarkings).toString());
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        NumberFormat vmaxnf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        vmaxnf.setMinimumFractionDigits(2);
        if (null != kps.getMichaelisConstants()) {
            List<MichaelisConstant> michaelisConstants = kps.getMichaelisConstants();
            for (MichaelisConstant michaelisConstant : michaelisConstants) {
                StringBuilder km = new StringBuilder();
                if (includeFlatFileMarkings) {
                    km.append("CC         ");
                }
                km.append(KM2);
                val = michaelisConstant.getConstantStr();
                if (Strings.isNullOrEmpty((String)val)) {
                    val = nf.format(michaelisConstant.getConstant());
                    val2 = "" + michaelisConstant.getConstant();
                    if (val.contains(".")) {
                        val = val2;
                    }
                }
                val = val.replace(",", "");
                km.append(val);
                km.append(" ");
                km.append(michaelisConstant.getUnit().toDisplayNameString());
                km.append(FOR);
                km.append(michaelisConstant.getSubstrate().getValue());
                lines.addAll(this.addEvidences(km, michaelisConstant, includeFlatFileMarkings, showEvidence, ";", ";"));
            }
        }
        if (null != kps.getMaximumVelocities() && !kps.getMaximumVelocities().isEmpty()) {
            List<MaximumVelocity> maximumVelocities = kps.getMaximumVelocities();
            for (MaximumVelocity maximumVelocity : maximumVelocities) {
                StringBuilder vm = new StringBuilder();
                if (includeFlatFileMarkings) {
                    vm.append("CC         ");
                }
                vm.append(VMAX);
                val = maximumVelocity.getVelocityStr();
                if (Strings.isNullOrEmpty((String)val)) {
                    val = vmaxnf.format(maximumVelocity.getVelocity());
                    val2 = "" + maximumVelocity.getVelocity();
                    if (val.contains(".")) {
                        val = val2;
                    }
                }
                val = val.replace(",", "");
                vm.append(val);
                vm.append(" ");
                vm.append(maximumVelocity.getMaxVelocityUnit().getValue());
                vm.append(" ");
                vm.append(maximumVelocity.getEnzyme().getValue());
                lines.addAll(this.addEvidences(vm, maximumVelocity, includeFlatFileMarkings, showEvidence, ";", ";"));
            }
        }
        if (kps.hasKineticParameterNote()) {
            lines.addAll(this.buildNote(kps.getNote(), includeFlatFileMarkings, showEvidence));
        }
        return lines;
    }

    private List<String> addEvidences(StringBuilder sb, HasEvidences he, boolean includeFlatFileMarkings, boolean showEvidence, String postfix, String postfixNoEvidence) {
        ArrayList<String> lines = new ArrayList<String>();
        sb = this.addEvidence(he, sb, showEvidence, postfix, postfixNoEvidence);
        String[] seps = new String[]{" ", "-"};
        if (includeFlatFileMarkings) {
            lines.addAll(FFLineWrapper.buildLines(sb.toString(), seps, "CC         ", 80));
        } else {
            lines.add(sb.toString());
        }
        return lines;
    }

    private List<String> buildPHDepLine(PHDependence depend, boolean includeFlatFileMarkings, boolean showEvidence) {
        return this.buildDependence(depend, P_H_DEPENDENCE, includeFlatFileMarkings, showEvidence);
    }

    private List<String> buildRedoxLine(RedoxPotential redox, boolean includeFlatFileMarkings, boolean showEvidence) {
        return this.buildDependence(redox, REDOX_POTENTIAL, includeFlatFileMarkings, showEvidence);
    }

    private List<String> buildTempLine(TemperatureDependence temp, boolean includeFlatFileMarkings, boolean showEvidence) {
        return this.buildDependence(temp, TEMPERATURE_DEPENDENCE, includeFlatFileMarkings, showEvidence);
    }

    private List<String> buildDependence(HasFreeText depend, String prefix, boolean includeFlatFileMarkings, boolean showEvidence) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(this.buildStart(prefix, includeFlatFileMarkings).toString());
        StringBuilder noteBuilder = new StringBuilder();
        if (includeFlatFileMarkings) {
            noteBuilder.append("CC         ");
        }
        String freeTextStr = this.buildFreeText(depend, showEvidence, ".", ";");
        noteBuilder.append(freeTextStr);
        if (includeFlatFileMarkings) {
            lines.addAll(FFLineWrapper.buildLines(noteBuilder, " ", "CC         "));
        } else {
            lines.add(noteBuilder.toString());
        }
        return lines;
    }
}

