/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.FlatFileWriter;
import uk.ac.ebi.kraken.ffwriter.LineType;
import uk.ac.ebi.kraken.ffwriter.line.FFLine;
import uk.ac.ebi.kraken.ffwriter.line.FFLines;
import uk.ac.ebi.kraken.ffwriter.line.impl.ACLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.CCLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.DELineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.DRLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.DTLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.FTLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.GNLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.IDLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.KWLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.OCLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.OGLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.OHLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.OSLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.OXLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.PELineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.SQLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.SSLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.rlines.RLineBuilder;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseCrossReference;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.internalsection.InternalLine;
import uk.ac.ebi.kraken.interfaces.uniprot.internalsection.InternalLineType;
import uk.ac.ebi.kraken.model.uniprot.dbx.CrossReferenceDatabaseContext;

public class UniProtFlatfileWriter {
    private static final ACLineBuilder AC_LINE_BUILDER = new ACLineBuilder();
    private static final CCLineBuilder CC_LINE_BUILDER = new CCLineBuilder();
    private static final DELineBuilder DE_LINE_BUILDER = new DELineBuilder();
    private static final DRLineBuilder DR_LINE_BUILDER = new DRLineBuilder();
    private static final DTLineBuilder DT_LINE_BUILDER = new DTLineBuilder();
    private static final FTLineBuilder FT_LINE_BUILDER = new FTLineBuilder();
    private static final GNLineBuilder GN_LINE_BUILDER = new GNLineBuilder();
    private static final IDLineBuilder ID_LINE_BUILDER = new IDLineBuilder();
    private static final KWLineBuilder KW_LINE_BUILDER = new KWLineBuilder();
    private static final OCLineBuilder OC_LINE_BUILDER = new OCLineBuilder();
    private static final OGLineBuilder OG_LINE_BUILDER = new OGLineBuilder();
    private static final OHLineBuilder OH_LINE_BUILDER = new OHLineBuilder();
    private static final OSLineBuilder OS_LINE_BUILDER = new OSLineBuilder();
    private static final OXLineBuilder OX_LINE_BUILDER = new OXLineBuilder();
    private static final RLineBuilder R_LINE_BUILDER = new RLineBuilder();
    private static final SSLineBuilder SS_LINE_BUILDER = new SSLineBuilder();
    private static final SQLineBuilder SQ_LINE_BUILDER = new SQLineBuilder();
    private static final PELineBuilder PE_LINE_BUILDER = new PELineBuilder();
    private static final List<String> COPYRIGHT = Arrays.asList("CC   ---------------------------------------------------------------------------", "CC   Copyrighted by the UniProt Consortium, see https://www.uniprot.org/terms", "CC   Distributed under the Creative Commons Attribution (CC BY 4.0) License", "CC   ---------------------------------------------------------------------------");
    private static final FFLine COPYRIGHT_LINE = FFLines.create(COPYRIGHT);
    private static final String ENTRY_END = "//";

    public static String write(UniProtEntry entry) {
        return UniProtFlatfileWriter.write(entry, true, true);
    }

    public static String write(UniProtEntry entry, Collection<LineType> types) {
        FFLine entryLines = FFLines.create();
        if (types.contains((Object)LineType.ID)) {
            entryLines.add(ID_LINE_BUILDER.build(entry));
        }
        if (types.contains((Object)LineType.AC)) {
            ArrayList<UniProtAccession> acc = new ArrayList<UniProtAccession>();
            acc.add(entry.getPrimaryUniProtAccession());
            acc.addAll(entry.getSecondaryUniProtAccessions());
            entryLines.add(AC_LINE_BUILDER.buildWithEvidence(acc));
        }
        if (types.contains((Object)LineType.DT)) {
            entryLines.add(DT_LINE_BUILDER.buildWithEvidence(entry));
        }
        if (types.contains((Object)LineType.DE)) {
            entryLines.add(DE_LINE_BUILDER.buildWithEvidence(entry.getProteinDescription()));
        }
        if (types.contains((Object)LineType.GN)) {
            entryLines.add(GN_LINE_BUILDER.buildWithEvidence(entry.getGenes()));
        }
        if (types.contains((Object)LineType.OS)) {
            entryLines.add(OS_LINE_BUILDER.buildWithEvidence(entry.getOrganism()));
        }
        if (types.contains((Object)LineType.OG)) {
            entryLines.add(OG_LINE_BUILDER.buildWithEvidence(entry.getOrganelles()));
        }
        if (types.contains((Object)LineType.OC)) {
            entryLines.add(OC_LINE_BUILDER.buildWithEvidence(entry.getTaxonomy()));
        }
        if (types.contains((Object)LineType.OX)) {
            entryLines.add(OX_LINE_BUILDER.buildWithEvidence(entry.getNcbiTaxonomyIds()));
        }
        if (types.contains((Object)LineType.OH)) {
            entryLines.add(OH_LINE_BUILDER.buildWithEvidence(entry.getOrganismHosts()));
        }
        if (types.contains((Object)LineType.RA) || types.contains((Object)LineType.RC) || types.contains((Object)LineType.RL) || types.contains((Object)LineType.RN) || types.contains((Object)LineType.RP) || types.contains((Object)LineType.RT) || types.contains((Object)LineType.RG) || types.contains((Object)LineType.RX)) {
            int citationNum = 0;
            for (Citation citation : entry.getCitationsNew()) {
                R_LINE_BUILDER.setRN(++citationNum);
                entryLines.add(R_LINE_BUILDER.buildWithEvidence(citation));
            }
        }
        if (types.contains((Object)LineType.CC)) {
            entryLines.add(UniProtFlatfileWriter.buildComment(entry, true));
        }
        if (types.contains((Object)LineType.CR)) {
            entryLines.add(COPYRIGHT_LINE);
        }
        if (types.contains((Object)LineType.DR)) {
            entryLines.add(UniProtFlatfileWriter.buildDRLines(entry, true));
        }
        if (types.contains((Object)LineType.PE)) {
            entryLines.add(PE_LINE_BUILDER.buildWithEvidence(entry.getProteinExistence()));
        }
        if (types.contains((Object)LineType.KW)) {
            entryLines.add(KW_LINE_BUILDER.buildWithEvidence(entry.getKeywords()));
        }
        if (types.contains((Object)LineType.FT)) {
            entryLines.add(FT_LINE_BUILDER.buildWithEvidence(entry.getFeatures()));
        }
        if (types.contains((Object)LineType.STAR_STAR)) {
            entryLines.add(SS_LINE_BUILDER.buildWithEvidence(entry));
        }
        if (types.contains((Object)LineType.SQ)) {
            entryLines.add(SQ_LINE_BUILDER.buildWithEvidence(entry.getSequence()));
        }
        entryLines.add(ENTRY_END);
        return entryLines.toString();
    }

    public static String write(UniProtEntry entry, boolean hasCopyRight, boolean hasInternalSection) {
        HashSet<LineType> set = new HashSet<LineType>(FlatFileWriter.ALL_LINES);
        if (!hasCopyRight) {
            set.remove((Object)LineType.CR);
        }
        if (!hasInternalSection) {
            set.remove((Object)LineType.STAR_STAR);
        }
        return UniProtFlatfileWriter.write(entry, set);
    }

    private static FFLine buildComment(UniProtEntry entry, boolean showEvidence) {
        FFLine ccLines = FFLines.create();
        for (CommentType commentType : CommentType.values()) {
            List comments = entry.getComments(commentType);
            if (comments.isEmpty()) continue;
            if (showEvidence) {
                ccLines.add(CC_LINE_BUILDER.buildWithEvidence(comments));
                continue;
            }
            ccLines.add(CC_LINE_BUILDER.build(comments));
        }
        return ccLines;
    }

    private static FFLine buildDRLines(UniProtEntry entry, boolean showEvidence) {
        FFLine drLines = FFLines.create();
        for (String databaseType : CrossReferenceDatabaseContext.INSTANCE.getAllXrefDBName()) {
            List<DatabaseCrossReference> listDBXref = entry.getDatabaseCrossReferences(databaseType);
            if (listDBXref.isEmpty()) continue;
            if (showEvidence) {
                drLines.add(DR_LINE_BUILDER.buildWithEvidence(listDBXref));
                continue;
            }
            drLines.add(DR_LINE_BUILDER.build(listDBXref));
        }
        for (InternalLine line : entry.getInternalSection().getInternalLines()) {
            if (InternalLineType.PROSITE != line.getInternalLineType()) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("**   ");
            sb.append((Object)line.getInternalLineType());
            sb.append("; ");
            sb.append(line.getValue());
            drLines.add(sb.toString());
        }
        return drLines;
    }
}

