/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl;

import java.util.ArrayList;
import uk.ac.ebi.kraken.ffwriter.LineType;
import uk.ac.ebi.kraken.ffwriter.line.FFLine;
import uk.ac.ebi.kraken.ffwriter.line.FFLines;
import uk.ac.ebi.kraken.ffwriter.line.impl.FFLineBuilderAbstr;
import uk.ac.ebi.kraken.ffwriter.line.impl.SSEvidenceLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.SSInternalLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.SSSourceLineBuilder;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;

public class SSLineBuilder
extends FFLineBuilderAbstr<UniProtEntry> {
    private static final String INTERNAL_SECTION = "**   #################    INTERNAL SECTION    ##################";
    private static final String START_LINE = "**";
    private SSSourceLineBuilder sourceLineBuilder = new SSSourceLineBuilder();
    private SSEvidenceLineBuilder evidenceLineBuilder = new SSEvidenceLineBuilder();
    private SSInternalLineBuilder internalLineBuilder = new SSInternalLineBuilder();

    public SSLineBuilder() {
        super(LineType.STAR_STAR);
    }

    @Override
    public String buildString(UniProtEntry f) {
        return this.buildLine(f, false).toString();
    }

    @Override
    public String buildStringWithEvidence(UniProtEntry f) {
        return this.buildLine(f, true).toString();
    }

    @Override
    protected FFLine buildLine(UniProtEntry f, boolean showEvidence) {
        FFLine sourceLines = this.sourceLineBuilder.buildWithEvidence(f.getInternalSection().getSourceLines());
        FFLine evidenceLines = this.evidenceLineBuilder.buildWithEvidence(f.getEvidences());
        FFLine internalLines = this.internalLineBuilder.buildWithEvidence(f.getInternalSection().getInternalLines());
        evidenceLines.add(internalLines);
        ArrayList<String> lines = new ArrayList<String>();
        if (sourceLines.isEmpty() && evidenceLines.isEmpty()) {
            return FFLines.create(lines);
        }
        lines.add(START_LINE);
        lines.addAll(sourceLines.lines());
        if (!evidenceLines.isEmpty()) {
            lines.add(INTERNAL_SECTION);
            lines.addAll(evidenceLines.lines());
        }
        return FFLines.create(lines);
    }
}

