/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import uk.ac.ebi.kraken.ffwriter.LineType;
import uk.ac.ebi.kraken.ffwriter.line.FFLine;
import uk.ac.ebi.kraken.ffwriter.line.FFLines;
import uk.ac.ebi.kraken.ffwriter.line.impl.FFLineBuilderAbstr;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.Evidence;
import uk.ac.ebi.kraken.util.thread.SimpleDateFormatThreadSafe;

public class SSEvidenceLineBuilder
extends FFLineBuilderAbstr<List<Evidence>> {
    private static final String PREFIX = "**EV ";
    private static final String DEFAULT_ORIG_NAME = "-";
    private static SimpleDateFormat formatter = new SimpleDateFormatThreadSafe("dd-MMM-yyyy", Locale.ENGLISH);

    public SSEvidenceLineBuilder() {
        super(LineType.STAR_STAR);
    }

    @Override
    public String buildString(List<Evidence> f) {
        return this.buildLine(f, false).toString();
    }

    @Override
    public String buildStringWithEvidence(List<Evidence> f) {
        return this.buildLine(f, true).toString();
    }

    @Override
    protected FFLine buildLine(List<Evidence> evidences, boolean showEvidence) {
        ArrayList<String> lines = new ArrayList<String>();
        if (evidences == null || evidences.isEmpty()) {
            return FFLines.create(lines);
        }
        Collections.sort(evidences, (o1, o2) -> 0);
        for (Evidence line : evidences) {
            StringBuilder sb = new StringBuilder();
            sb.append(PREFIX);
            if (line.getEvidenceId().useECOCode()) {
                sb.append(line.getEvidenceCode().getCodeValue());
                sb.append("; ");
                if (!line.getAttribute().getValue().isEmpty() && !line.getAttribute().getValue().equals(DEFAULT_ORIG_NAME)) {
                    if (!line.getEvidenceId().getTypeValue().isEmpty()) {
                        sb.append(line.getEvidenceId().getTypeValue());
                        sb.append(":");
                    }
                    sb.append(line.getEvidenceId().getAttribute().getValue());
                } else {
                    sb.append(DEFAULT_ORIG_NAME);
                }
                sb.append("; ");
                if (line.getOriginName().getValue().isEmpty()) {
                    sb.append(DEFAULT_ORIG_NAME);
                } else {
                    sb.append(line.getOriginName().getValue());
                }
            } else {
                sb.append(line.getEvidenceId().getValue());
                sb.append("; ");
                sb.append(line.getType().getValue());
                sb.append("; ");
                sb.append(line.getOriginName().getValue());
                sb.append("; ");
                sb.append(line.getAttribute().getValue());
            }
            sb.append("; ");
            sb.append(formatter.format(line.getDate()).toUpperCase());
            sb.append(".");
            lines.add(sb.toString());
        }
        return FFLines.create(lines);
    }
}

