/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.LineType;
import uk.ac.ebi.kraken.ffwriter.line.FFLine;
import uk.ac.ebi.kraken.ffwriter.line.FFLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.FFLines;
import uk.ac.ebi.kraken.ffwriter.line.LineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.FFLineBuilderAbstr;
import uk.ac.ebi.kraken.interfaces.common.Value;
import uk.ac.ebi.kraken.interfaces.uniprot.Gene;
import uk.ac.ebi.kraken.interfaces.uniprot.HasEvidences;

public class GNLineBuilder
extends FFLineBuilderAbstr<List<Gene>>
implements FFLineBuilder<List<Gene>> {
    private static final String ORF_NAMES = "ORFNames=";
    private static final String ORDERED_LOCUS_NAMES = "OrderedLocusNames=";
    private static final String SYNONYMS = "Synonyms=";
    private static final String NAME = "Name=";

    public GNLineBuilder() {
        super(LineType.GN);
    }

    @Override
    public String buildString(List<Gene> f) {
        ArrayList<String> lines = new ArrayList<String>();
        boolean isFirst = true;
        for (Gene gene : f) {
            if (!isFirst) {
                lines.add(" and ");
            }
            lines.addAll(this.buildLines(gene, false));
            isFirst = false;
        }
        return FFLines.create(lines).toString();
    }

    @Override
    public String buildStringWithEvidence(List<Gene> f) {
        ArrayList<String> lines = new ArrayList<String>();
        boolean isFirst = true;
        for (Gene gene : f) {
            if (!isFirst) {
                lines.add(" and ");
            }
            lines.addAll(this.buildLines(gene, true));
            isFirst = false;
        }
        return FFLines.create(lines).toString();
    }

    @Override
    protected FFLine buildLine(List<Gene> f, boolean showEvidence) {
        ArrayList<String> lines = new ArrayList<String>();
        boolean isFirst = true;
        for (Gene gene : f) {
            if (!isFirst) {
                lines.add(this.linePrefix + "and");
            }
            lines.addAll(this.buildLines(gene, showEvidence));
            isFirst = false;
        }
        return FFLines.create(lines);
    }

    private List<String> buildLines(Gene gene, boolean showEvidence) {
        StringBuilder gORFBuilder;
        StringBuilder gOLNBuilder;
        StringBuilder gSBuilder;
        ArrayList<String> lines = new ArrayList<String>();
        if (!this.hasGene(gene)) {
            return lines;
        }
        LineBuilder lineBuilder = new LineBuilder(this.linePrefix, this.lineType);
        ArrayList<StringBuilder> typeBuilders = new ArrayList<StringBuilder>();
        if (gene.hasGeneName()) {
            StringBuilder gnBuilder = new StringBuilder();
            gnBuilder.append(NAME);
            this.addValue(gnBuilder, gene.getGeneName(), showEvidence, gene.getGeneName(), 1, 1);
            typeBuilders.add(gnBuilder);
        }
        if ((gSBuilder = this.addGeneItems(SYNONYMS, gene.getGeneNameSynonyms(), showEvidence)) != null) {
            typeBuilders.add(gSBuilder);
        }
        if ((gOLNBuilder = this.addGeneItems(ORDERED_LOCUS_NAMES, gene.getOrderedLocusNames(), showEvidence)) != null) {
            typeBuilders.add(gOLNBuilder);
        }
        if ((gORFBuilder = this.addGeneItems(ORF_NAMES, gene.getORFNames(), showEvidence)) != null) {
            typeBuilders.add(gORFBuilder);
        }
        for (StringBuilder typeBuilder : typeBuilders) {
            lineBuilder.addItem(typeBuilder.toString(), " ");
        }
        lineBuilder.finish("");
        return lineBuilder.getLines();
    }

    private <T extends HasEvidences> StringBuilder addGeneItems(String prefix, List<T> genes, boolean showEvidence) {
        int size = genes.size();
        if (size == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        int count = 0;
        for (HasEvidences orfName : genes) {
            this.addValue(sb, (Value)((Object)orfName), showEvidence, orfName, ++count, size);
        }
        return sb;
    }

    private void addValue(StringBuilder sb, Value value, boolean showEvidence, HasEvidences he, int count, int totalNumber) {
        sb.append(value.getValue());
        this.addEvidences(sb, he, showEvidence);
        if (count < totalNumber) {
            sb.append(", ");
        } else {
            sb.append(";");
        }
    }

    private boolean hasGene(Gene gene) {
        return gene.hasGeneName() || !gene.getGeneNameSynonyms().isEmpty() || !gene.getOrderedLocusNames().isEmpty() || !gene.getORFNames().isEmpty();
    }
}

