/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.LineType;
import uk.ac.ebi.kraken.ffwriter.line.FFLineWrapper;

public class LineBuilder {
    private final String prefix;
    private List<String> lines = new ArrayList<String>();
    private StringBuilder currentLine = new StringBuilder();
    public static final int LINE_LENGTH = 75;
    private int lineLength = 75;
    private final String lineStart;
    private final LineType lineType;

    public LineBuilder(String prefix, LineType lineType) {
        this.prefix = prefix;
        this.currentLine.append(prefix);
        this.lineStart = prefix;
        this.lineType = lineType;
    }

    public void setLineLength(int length) {
        this.lineLength = length;
    }

    public void addItem(String item, String separator) {
        if (this.currentLine.toString().equals(this.lineStart)) {
            this.currentLine.append(item);
            this.resetCurrentLine(separator);
        } else if (this.currentLine.length() + item.length() + separator.length() > this.lineLength) {
            this.lines.add(this.currentLine.toString());
            this.currentLine = new StringBuilder();
            this.currentLine.append(this.prefix);
            this.currentLine.append(item);
            this.resetCurrentLine(separator);
        } else {
            this.currentLine.append(separator);
            this.currentLine.append(item);
        }
    }

    private void resetCurrentLine(String separator) {
        if (this.currentLine.length() > this.lineLength) {
            List<String> tempLines = FFLineWrapper.buildLines(this.currentLine.toString(), separator, (Object)((Object)this.lineType) + "   ", this.lineLength);
            for (int i = 0; i < tempLines.size() - 1; ++i) {
                this.lines.add(tempLines.get(i));
            }
            this.currentLine = new StringBuilder(tempLines.get(tempLines.size() - 1));
        }
    }

    public void finish(String end) {
        if (!this.currentLine.toString().equals(this.lineStart)) {
            this.currentLine.append(end);
            this.lines.add(this.currentLine.toString());
        }
    }

    public List<String> getLines() {
        return this.lines;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String line : this.lines) {
            sb.append(line).append('\n');
        }
        return sb.toString();
    }
}

