/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;

public class EvidenceLine {
    private static final String SEPARATOR1 = ",";
    private static final String SEPARATOR2 = ", ";

    public static String export(List<EvidenceId> evIds) {
        String s = "";
        Collections.sort(evIds);
        boolean first = true;
        boolean isEco = false;
        for (EvidenceId evid : evIds) {
            if (evid.getValue().startsWith("ECO")) {
                isEco = true;
            }
            if (!first) {
                s = evid.getValue().startsWith("ECO") ? s + SEPARATOR2 : s + SEPARATOR1;
            }
            s = s + evid.getValue();
            first = false;
        }
        if (s.length() > 0) {
            s = isEco ? " {" + s + "}" : "{" + s + "}";
        }
        return s;
    }

    public static class EvidenceIdComparator
    implements Comparator<EvidenceId> {
        @Override
        public int compare(EvidenceId ev1, EvidenceId ev2) {
            String val1 = ev1.getValue();
            String val2 = ev2.getValue();
            if (val1.substring(0, 2).compareTo(val2.substring(0, 2)) != 0) {
                return val1.substring(0, 2).compareTo(val2.substring(0, 2));
            }
            Integer intVa1 = Integer.parseInt(val1.substring(2));
            Integer intVa2 = Integer.parseInt(val2.substring(2));
            return intVa1.compareTo(intVa2);
        }
    }
}

