/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.prosplign.cli;

import es.uvigo.ei.sing.yacli.command.option.DefaultValuedStringOption;
import es.uvigo.ei.sing.yacli.command.option.FileOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.option.StringOption;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.sing_group.seda.blast.cli.blast.BlastCommand;
import org.sing_group.seda.cli.ExternalSoftwareExecutionCommand;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.plugin.spi.TransformationProvider;
import org.sing_group.seda.prosplign.execution.AbstractProSplignCompartBinariesExecutor;
import org.sing_group.seda.prosplign.execution.DefaultProSplignCompartBinariesExecutor;
import org.sing_group.seda.prosplign.execution.DockerProSplignCompartBinariesExecutor;
import org.sing_group.seda.prosplign.execution.ProSplignCompartBinariesExecutor;
import org.sing_group.seda.prosplign.plugin.core.ProSplignCompartPipelineSedaPluginInfo;
import org.sing_group.seda.prosplign.transformation.provider.ProSplignCompartPipelineTransformationProvider;

public class ProSplignCompartPipelineCommand
extends ExternalSoftwareExecutionCommand {
    public static final StringOption OPTION_PROSPLIGN_PROCOMPART_DOCKER_MODE = new StringOption(SOFTWARE_EXECUTION_CATEGORY, "prosplign-procompart-docker-mode", "prosplign-procompart-dk", "The ProSplign/ProCompart docker image. By default, the official SEDA image is used. If you provide a custom image, it should have the prosplign and procompart-wrapper commands available in the path.", true, true);
    public static final StringOption OPTION_PROSPLIGN_PROCOMPART_LOCAL_MODE = new StringOption(SOFTWARE_EXECUTION_CATEGORY, "prosplign-procompart-local-mode", "prosplign-procompart-lc", "The directory that contains the ProSplign/ProCompart binaries. Leave it empty if they are in the path. Check the SEDA manual to see how to obtain them.", true, true);
    public static final FileOption OPTION_EXTERNAL_QUERY_FILE = new FileOption("query-file", "qf", "The query file (proteins).", true, true);
    public static final DefaultValuedStringOption OPTION_MAX_TARGET_SEQS = new DefaultValuedStringOption("max-target-seqs", "mts", "Value of the max_target_seqs BLAST parameter.", Integer.toString(1));
    public static final StringOption OPTION_BLAST_DOCKER_MODE = new StringOption(SOFTWARE_EXECUTION_CATEGORY, "blast-docker-mode", "blast-dk", "The BLAST docker image. By default, the official SEDA image for BLAST is used. If you provide a custom image, it should have the BLAST commands available in the path.", true, true);
    public static final StringOption OPTION_BLAST_LOCAL_MODE = new StringOption(SOFTWARE_EXECUTION_CATEGORY, "blast-local-mode", "blast-lc", "The directory that contains the BLAST binaries. Leave it empty if they are in the path.", true, true);

    public String getName() {
        return "prosplign-procompart";
    }

    public String getDescriptiveName() {
        return "ProSplign/ProCompart Pipeline";
    }

    public String getDescription() {
        return "Obtain CDS annotations with ProSplign/ProCompart, using selected files and a file with reference protein sequences.";
    }

    @Override
    protected String getSedaGroup() {
        return ProSplignCompartPipelineSedaPluginInfo.GROUP;
    }

    @Override
    protected List<Option<?>> getMandatoryOptions() {
        return Arrays.asList(OPTION_EXTERNAL_QUERY_FILE);
    }

    @Override
    protected List<Option<?>> getLocalOptionsList() {
        return Arrays.asList(OPTION_PROSPLIGN_PROCOMPART_LOCAL_MODE, OPTION_BLAST_LOCAL_MODE);
    }

    @Override
    protected Map<Option<?>, String> getLocalOptionsToEnablePropertyMap() {
        return ProSplignCompartPipelineCommand.fromLists(this.getLocalOptionsList(), Arrays.asList("seda.local.execution.enabled.prosplignprocompart", "seda.local.execution.enabled.blast"));
    }

    @Override
    protected List<Option<?>> createExternalSedaOptions() {
        return Arrays.asList(OPTION_PROSPLIGN_PROCOMPART_LOCAL_MODE, OPTION_PROSPLIGN_PROCOMPART_DOCKER_MODE, OPTION_EXTERNAL_QUERY_FILE, OPTION_MAX_TARGET_SEQS, OPTION_BLAST_LOCAL_MODE, OPTION_BLAST_DOCKER_MODE);
    }

    @Override
    protected TransformationProvider getTransformation(Parameters parameters) {
        ProSplignCompartPipelineTransformationProvider provider = new ProSplignCompartPipelineTransformationProvider();
        provider.setProteinQueryFile(this.getExistingFile(parameters, OPTION_EXTERNAL_QUERY_FILE));
        provider.setMaxTargetSeqs(this.getIntegerFromStringOption(parameters, (Option<String>)OPTION_MAX_TARGET_SEQS));
        provider.setProSplignCompartBinariresExecutor(Optional.of(this.getProSplignProCompartBinariesExecutor(parameters)));
        provider.setBlastBinariesExecutor(Optional.of(BlastCommand.getBlastBinariesExecutor((Parameters)parameters, (StringOption)OPTION_BLAST_LOCAL_MODE, (StringOption)OPTION_BLAST_DOCKER_MODE)));
        return provider;
    }

    private ProSplignCompartBinariesExecutor getProSplignProCompartBinariesExecutor(Parameters parameters) {
        ProSplignCompartPipelineCommand.validateSingleExecutionMode(parameters, OPTION_PROSPLIGN_PROCOMPART_LOCAL_MODE, OPTION_PROSPLIGN_PROCOMPART_DOCKER_MODE, " for ProSplign/ProCompart");
        AbstractProSplignCompartBinariesExecutor executor = new DockerProSplignCompartBinariesExecutor(DockerProSplignCompartBinariesExecutor.getDefaultDockerImage());
        if (parameters.hasOption((Option)OPTION_PROSPLIGN_PROCOMPART_LOCAL_MODE)) {
            File splignCompartDirectory = new File(parameters.getSingleValueString((Option)OPTION_PROSPLIGN_PROCOMPART_LOCAL_MODE));
            if (splignCompartDirectory.isDirectory()) {
                executor = new DefaultProSplignCompartBinariesExecutor(splignCompartDirectory);
            } else {
                ProSplignCompartPipelineCommand.formattedValidationError("The specified ProSplign/ProCompart directory does not exist or it is not a directory.");
            }
        }
        if (parameters.hasOption((Option)OPTION_PROSPLIGN_PROCOMPART_DOCKER_MODE)) {
            executor = new DockerProSplignCompartBinariesExecutor((String)parameters.getSingleValue((Option)OPTION_PROSPLIGN_PROCOMPART_DOCKER_MODE));
        }
        return executor;
    }

    @Override
    protected TransformationProvider getTransformation(File parametersFile) throws IOException {
        return (TransformationProvider)new JsonObjectReader().read(parametersFile, ProSplignCompartPipelineTransformationProvider.class);
    }
}

