/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.handlers.addressing;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultSubCode;
import org.apache.axiom.soap.SOAPFaultText;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingConstants;
import org.apache.axis2.addressing.AddressingFaultsHelper;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;

public class AddressingInFaultHandler
extends AbstractHandler
implements AddressingConstants {
    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        String action = msgContext.getWSAAction();
        if ("http://www.w3.org/2005/08/addressing/fault".equals(action) || "http://www.w3.org/2005/08/addressing/soap/fault".equals(action) || "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault".equals(action)) {
            String faultLocalName;
            SOAPFaultCode code;
            SOAPFaultSubCode subCode;
            OMElement element;
            SOAPEnvelope envelope = msgContext.getEnvelope();
            SOAPFault fault = envelope.getBody().getFault();
            if (fault == null) {
                throw new AxisFault("A Soap envelope with fault action -" + action + " has been received without " + "a fault element in the soap body");
            }
            SOAPFactory sf = (SOAPFactory)envelope.getOMFactory();
            SOAPFaultDetail detail = null;
            if (msgContext.isSOAP11()) {
                SOAPHeader header = envelope.getHeader();
                element = header.getFirstChildWithName(AddressingConstants.Final.QNAME_WSA_HEADER_DETAIL);
                if (element != null) {
                    detail = sf.createSOAPFaultDetail(fault);
                    Iterator i = element.getChildElements();
                    while (i.hasNext()) {
                        OMElement detailElement = (OMElement)i.next();
                        i.remove();
                        detail.addDetailEntry(detailElement);
                    }
                }
            } else {
                detail = fault.getDetail();
            }
            String faultDetailString = null;
            if (detail != null && (element = detail.getFirstElement()) != null) {
                faultDetailString = element.getText();
            }
            if ((subCode = (code = fault.getCode()).getSubCode()) == null) {
                faultLocalName = code.getTextAsQName().getLocalPart();
            } else {
                while (subCode.getSubCode() != null) {
                    subCode = subCode.getSubCode();
                }
                faultLocalName = subCode.getValue().getTextAsQName().getLocalPart();
            }
            String newReason = AddressingFaultsHelper.getMessageForAxisFault(faultLocalName, faultDetailString);
            if (newReason != null) {
                SOAPFaultReason sfr = sf.createSOAPFaultReason();
                if (envelope.getNamespace().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
                    sfr.setText(newReason);
                } else {
                    SOAPFaultText sft = sf.createSOAPFaultText();
                    sft.setText(newReason);
                    sfr.addSOAPText(sft);
                }
                AxisFault axisFault = new AxisFault(fault.getCode(), sfr, fault.getNode(), fault.getRole(), detail);
                msgContext.setProperty("inboundFaultOverride", axisFault);
            }
        }
        return Handler.InvocationResponse.CONTINUE;
    }
}

