/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.sequencesgroup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequenceBuilder;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.SequencesGroupBuilder;
import org.sing_group.seda.transformation.TransformationException;
import org.sing_group.seda.transformation.sequencesgroup.SequencesGroupTransformation;
import org.sing_group.seda.util.StringUtils;

public class DisambiguateSequenceNamesTransformation
implements SequencesGroupTransformation {
    private final SequenceBuilder seqBuilder;
    private final SequencesGroupBuilder builder = factory::newSequencesGroup;
    private Mode mode;

    public DisambiguateSequenceNamesTransformation(Mode mode) {
        this(mode, DatatypeFactory.getDefaultDatatypeFactory());
    }

    public DisambiguateSequenceNamesTransformation(Mode mode, DatatypeFactory factory) {
        this.seqBuilder = factory::newSequence;
        this.mode = mode;
    }

    @Override
    public SequencesGroup transform(SequencesGroup sequencesGroup) throws TransformationException {
        ArrayList<Sequence> newSequences = new ArrayList<Sequence>(sequencesGroup.getSequenceCount());
        HashMap nameToSequences = new HashMap();
        sequencesGroup.getSequences().forEach(sequence -> {
            nameToSequences.putIfAbsent(sequence.getName(), new LinkedList());
            ((List)nameToSequences.get(sequence.getName())).add(sequence);
        });
        boolean removeMode = this.mode.equals((Object)Mode.REMOVE);
        block0: for (Map.Entry entry : nameToSequences.entrySet()) {
            int i = 1;
            boolean addIndex = ((List)entry.getValue()).size() > 1 && !removeMode;
            for (Sequence s : (List)entry.getValue()) {
                String newSequenceName = s.getName();
                if (addIndex) {
                    newSequenceName = newSequenceName + "_" + i++;
                }
                newSequences.add(this.seqBuilder.of(newSequenceName, s.getDescription(), s.getChain(), s.getProperties()));
                if (!removeMode) continue;
                continue block0;
            }
        }
        return this.builder.of(sequencesGroup.getName(), sequencesGroup.getProperties(), newSequences);
    }

    public static enum Mode {
        RENAME,
        REMOVE;


        public String toString() {
            return StringUtils.capitalize(super.toString());
        }
    }
}

