/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.sequencesgroup;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sing_group.seda.bio.FunctionUtil;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.SequencesGroupBuilder;
import org.sing_group.seda.transformation.TransformationException;
import org.sing_group.seda.transformation.sequence.SequenceTransformation;
import org.sing_group.seda.transformation.sequencesgroup.SequencesGroupTransformation;

public class ComposedSequencesGroupTransformation
implements SequencesGroupTransformation {
    private final SequencesGroupBuilder builder = factory::newSequencesGroup;
    private final SequenceTransformation[] transformations;

    public ComposedSequencesGroupTransformation(SequenceTransformation ... transformations) {
        this(DatatypeFactory.getDefaultDatatypeFactory(), transformations);
    }

    public ComposedSequencesGroupTransformation(DatatypeFactory factory, SequenceTransformation ... transformations) {
        this.transformations = transformations;
    }

    public ComposedSequencesGroupTransformation(Collection<SequenceTransformation> transformations) {
        this((SequenceTransformation[])transformations.stream().toArray(SequenceTransformation[]::new));
    }

    public ComposedSequencesGroupTransformation(DatatypeFactory factory, Collection<SequenceTransformation> transformations) {
        this(factory, (SequenceTransformation[])transformations.stream().toArray(SequenceTransformation[]::new));
    }

    @Override
    public SequencesGroup transform(SequencesGroup sequencesGroup) throws TransformationException {
        Stream<Sequence> sequenceStream = (Stream<Sequence>)sequencesGroup.getSequences().parallel();
        for (SequenceTransformation transformation : this.transformations) {
            sequenceStream = sequenceStream.map(FunctionUtil.wrapWithExceptionToNull(s -> transformation.transform((Sequence)s), (s, e) -> {
                System.err.println("An exception occurred processing " + s.getName());
                System.err.println("Exception message: " + e.getMessage());
                if (e.getCause() != null) {
                    System.err.println("Exception message: " + e.getCause().getMessage());
                }
                System.err.println();
            })).filter(Objects::nonNull);
        }
        List<Sequence> sequences = sequenceStream.collect(Collectors.toList());
        if (sequences.size() == 0) {
            throw new TransformationException("Empty sequences after filtering");
        }
        return this.builder.of(sequencesGroup.getName(), sequencesGroup.getProperties(), sequences);
    }
}

