/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.provider.split.regex;

import java.io.File;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.core.filtering.RegexHeaderMatcher;
import org.sing_group.seda.core.split.HeaderMatcherSplitter;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.plugin.spi.AbstractTransformationProvider;
import org.sing_group.seda.plugin.spi.DefaultValidation;
import org.sing_group.seda.plugin.spi.Validation;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.dataset.SplitSequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.provider.split.regex.RegexSplitConfigurationChangeType;

@XmlRootElement
public class RegexSplitConfigurationTransformationProvider
extends AbstractTransformationProvider {
    @XmlElement
    private RegexHeaderMatcher regexHeaderMatcher;
    @XmlElement
    private File saveGroupNamesDirectory;

    @Override
    public Validation validate() {
        if (this.regexHeaderMatcher == null) {
            return new DefaultValidation("The regular expression header matcher is not defined.");
        }
        return new DefaultValidation(new String[0]);
    }

    @Override
    public SequencesGroupDatasetTransformation getTransformation(DatatypeFactory factory) {
        RegexHeaderMatcher headerMatcher = this.getRegexHeaderMatcher();
        HeaderMatcherSplitter splitter = this.saveGroupNamesDirectory == null ? new HeaderMatcherSplitter(headerMatcher) : new HeaderMatcherSplitter(headerMatcher, this.saveGroupNamesDirectory);
        return new SplitSequencesGroupDatasetTransformation(splitter, factory);
    }

    public void setHeaderMatcher(RegexHeaderMatcher newRegexHeaderMatcher) {
        if (this.regexHeaderMatcher == null || this.regexHeaderMatcher != newRegexHeaderMatcher) {
            this.regexHeaderMatcher = newRegexHeaderMatcher;
            this.fireTransformationsConfigurationModelEvent(RegexSplitConfigurationChangeType.HEADER_MATCHER_CHANGED, this.regexHeaderMatcher);
        }
    }

    public void removeHeaderMatcher() {
        this.regexHeaderMatcher = null;
        this.fireTransformationsConfigurationModelEvent(RegexSplitConfigurationChangeType.HEADER_MATCHER_CHANGED, this.regexHeaderMatcher);
    }

    public RegexHeaderMatcher getRegexHeaderMatcher() {
        return this.regexHeaderMatcher;
    }

    public File getSaveGroupNamesDirectory() {
        return this.saveGroupNamesDirectory;
    }

    public void setSaveGroupNamesDirectory(File newSaveGroupNamesDirectory) {
        if (this.saveGroupNamesDirectory == null || !this.saveGroupNamesDirectory.equals(newSaveGroupNamesDirectory)) {
            this.saveGroupNamesDirectory = newSaveGroupNamesDirectory;
            this.fireTransformationsConfigurationModelEvent(RegexSplitConfigurationChangeType.SAVE_GROUP_NAMES_FILES_DIRECTORY, this.saveGroupNamesDirectory);
        }
    }

    public void removeSaveGroupNamesDirectory() {
        this.saveGroupNamesDirectory = null;
        this.fireTransformationsConfigurationModelEvent(RegexSplitConfigurationChangeType.SAVE_GROUP_NAMES_FILES_DIRECTORY, this.saveGroupNamesDirectory);
    }
}

