/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.provider.pattern;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.SequenceTarget;
import org.sing_group.seda.datatype.configuration.SequenceTranslationConfiguration;
import org.sing_group.seda.datatype.pattern.EvaluableSequencePattern;
import org.sing_group.seda.plugin.spi.AbstractTransformationProvider;
import org.sing_group.seda.plugin.spi.DefaultValidation;
import org.sing_group.seda.plugin.spi.Validation;
import org.sing_group.seda.transformation.dataset.ComposedSequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.provider.pattern.PatternFilteringEventType;
import org.sing_group.seda.transformation.sequencesgroup.PatternFilteringSequencesGroupTransformation;

@XmlRootElement
public class PatternFilteringTransformationProvider
extends AbstractTransformationProvider {
    @XmlElement
    protected SequenceTarget target;
    @XmlElement
    protected SequenceTranslationConfiguration translationConfiguration;
    @XmlAnyElement(lax=true)
    protected EvaluableSequencePattern pattern;

    @Override
    public SequencesGroupDatasetTransformation getTransformation(DatatypeFactory factory) {
        PatternFilteringSequencesGroupTransformation patternTransformation = this.target.isSequence() && this.isTranslationSelected() ? new PatternFilteringSequencesGroupTransformation(this.pattern, this.translationConfiguration, factory) : new PatternFilteringSequencesGroupTransformation(this.pattern, this.target, factory);
        ComposedSequencesGroupDatasetTransformation datasetTransformation = new ComposedSequencesGroupDatasetTransformation(factory, patternTransformation);
        return datasetTransformation;
    }

    protected boolean isTranslationSelected() {
        return this.translationConfiguration != null;
    }

    @Override
    public Validation validate() {
        ArrayList<String> errorList = new ArrayList<String>();
        if (this.pattern == null) {
            errorList.add("Pattern is not defined.");
        } else {
            errorList.addAll(this.pattern.validate().getValidationErrors());
        }
        if (this.target == null) {
            errorList.add("Target is not defined.");
        }
        if (errorList.isEmpty()) {
            return new DefaultValidation(new String[0]);
        }
        return new DefaultValidation(errorList);
    }

    public void clearPattern() {
        this.pattern = null;
        this.fireTransformationsConfigurationModelEvent(PatternFilteringEventType.PATTERN_CLEARED, this.pattern);
    }

    public void setPattern(EvaluableSequencePattern pattern) {
        if (!(pattern == null || this.pattern != null && this.pattern.equals(pattern))) {
            this.pattern = pattern;
            this.fireTransformationsConfigurationModelEvent(PatternFilteringEventType.PATTERN_EDITED, this.pattern);
        }
    }

    public EvaluableSequencePattern getPattern() {
        return this.pattern;
    }

    public void setTranslationConfiguration(SequenceTranslationConfiguration translationConfiguration) {
        if (!(translationConfiguration == null || this.translationConfiguration != null && this.translationConfiguration.equals(translationConfiguration))) {
            this.translationConfiguration = translationConfiguration;
            this.fireTransformationsConfigurationModelEvent(PatternFilteringEventType.TRANSLATION_CONFIGURATION_CHANGED, this.translationConfiguration);
        }
    }

    public void clearTranslationConfiguration() {
        this.translationConfiguration = null;
        this.fireTransformationsConfigurationModelEvent(PatternFilteringEventType.TRANSLATION_CONFIGURATION_CHANGED, this.translationConfiguration);
    }

    public SequenceTranslationConfiguration getTranslationConfiguration() {
        return this.translationConfiguration;
    }

    public void setTarget(SequenceTarget target) {
        if (this.target == null || !this.target.equals((Object)target)) {
            this.target = target;
            this.fireTransformationsConfigurationModelEvent(PatternFilteringEventType.SEQUENCE_TARGET_CHANGED, (Object)this.target);
        }
    }

    public SequenceTarget getTarget() {
        return this.target;
    }
}

