/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.provider.filtering;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.core.filtering.HeaderFilteringConfiguration;
import org.sing_group.seda.core.filtering.HeaderMatcher;
import org.sing_group.seda.core.selection.SequenceIndexSelector;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.plugin.spi.AbstractTransformationProvider;
import org.sing_group.seda.plugin.spi.DefaultValidation;
import org.sing_group.seda.plugin.spi.Validation;
import org.sing_group.seda.transformation.dataset.ComposedSequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.dataset.HeaderCountFilteringSequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.dataset.SequenceCountFilterSequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.provider.filtering.FilteringConfigurationEventType;
import org.sing_group.seda.transformation.sequence.SequenceTransformation;
import org.sing_group.seda.transformation.sequencesgroup.ComposedSequencesGroupTransformation;
import org.sing_group.seda.transformation.sequencesgroup.FilterBySequenceLengthTransformation;
import org.sing_group.seda.transformation.sequencesgroup.FilterByStartCodonTransformation;
import org.sing_group.seda.transformation.sequencesgroup.HeaderCountFilteringSequencesGroupTransformation;
import org.sing_group.seda.transformation.sequencesgroup.RemoveBySizeSequencesGroupTransformation;
import org.sing_group.seda.transformation.sequencesgroup.RemoveInFrameStopCodonsSequencesGroupTransformation;
import org.sing_group.seda.transformation.sequencesgroup.RemoveNonTripletsSequencesGroupTransformation;
import org.sing_group.seda.transformation.sequencesgroup.SequencesGroupTransformation;

@XmlRootElement
public class FilteringConfigurationTransformationProvider
extends AbstractTransformationProvider {
    private static final String VALID_CODON_CHAR_REGEX = "[ACTG]{3}";
    @XmlElement
    private final SortedSet<String> startingCodons = new TreeSet<String>();
    private boolean removeNonMultipleOfThree = false;
    private boolean removeIfInFrameStopCodon = false;
    private boolean removeBySizeDifference = false;
    private int sizeDifference = 10;
    private int referenceIndex = 1;
    @XmlElement
    private File referenceFile;
    private int minNumOfSequences = 1;
    private int maxNumOfSequences = 0;
    private int minSequenceLength = 0;
    private int maxSequenceLength = 0;
    private HeaderFilteringConfiguration headerFilteringConfiguration = new HeaderFilteringConfiguration();

    @Override
    public SequencesGroupDatasetTransformation getTransformation(DatatypeFactory factory) {
        LinkedList<SequenceTransformation> seqTransformations = new LinkedList<SequenceTransformation>();
        LinkedList<SequencesGroupTransformation> sequencesGroupTransformations = new LinkedList<SequencesGroupTransformation>();
        LinkedList<SequencesGroupDatasetTransformation> datasetTransformations = new LinkedList<SequencesGroupDatasetTransformation>();
        if (!this.startingCodons.isEmpty() && this.startingCodons.size() != 64) {
            sequencesGroupTransformations.add(new FilterByStartCodonTransformation(this.startingCodons, factory));
        }
        if (this.removeNonMultipleOfThree) {
            sequencesGroupTransformations.add(new RemoveNonTripletsSequencesGroupTransformation(factory));
        }
        if (this.removeIfInFrameStopCodon) {
            sequencesGroupTransformations.add(new RemoveInFrameStopCodonsSequencesGroupTransformation(factory));
        }
        if (this.minSequenceLength > 0 || this.maxSequenceLength > 0) {
            sequencesGroupTransformations.add(new FilterBySequenceLengthTransformation(this.minSequenceLength, this.maxSequenceLength, factory));
        }
        if (this.minNumOfSequences > 1 || this.maxNumOfSequences > 1) {
            datasetTransformations.add(new SequenceCountFilterSequencesGroupDatasetTransformation(this.minNumOfSequences, this.maxNumOfSequences, factory));
        }
        if (this.removeBySizeDifference) {
            if (this.referenceFile == null) {
                sequencesGroupTransformations.add(new RemoveBySizeSequencesGroupTransformation(new SequenceIndexSelector(this.referenceIndex - 1), (double)this.sizeDifference / 100.0, factory));
            } else {
                sequencesGroupTransformations.add(new RemoveBySizeSequencesGroupTransformation(this.getReferenceSequence(factory).get(), (double)this.sizeDifference / 100.0, factory));
            }
        }
        if (!seqTransformations.isEmpty()) {
            sequencesGroupTransformations.add(new ComposedSequencesGroupTransformation(factory, seqTransformations));
        }
        if (this.headerFilteringConfiguration.isUseFilter()) {
            HeaderMatcher matcher = this.headerFilteringConfiguration.getHeaderMatcher();
            if (this.headerFilteringConfiguration.getLevel().equals((Object)HeaderFilteringConfiguration.Level.SEQUENCE)) {
                sequencesGroupTransformations.add(new HeaderCountFilteringSequencesGroupTransformation(factory, matcher, this.headerFilteringConfiguration.getMin(), this.headerFilteringConfiguration.getMax(), this.headerFilteringConfiguration.getMode().equals((Object)HeaderFilteringConfiguration.Mode.KEEP)));
            } else {
                datasetTransformations.add(new HeaderCountFilteringSequencesGroupDatasetTransformation(factory, matcher, this.headerFilteringConfiguration.getMin(), this.headerFilteringConfiguration.getMax(), this.headerFilteringConfiguration.getMode().equals((Object)HeaderFilteringConfiguration.Mode.KEEP)));
            }
        }
        if (!sequencesGroupTransformations.isEmpty()) {
            datasetTransformations.add(new ComposedSequencesGroupDatasetTransformation(factory, sequencesGroupTransformations));
        }
        if (datasetTransformations.size() == 1) {
            return (SequencesGroupDatasetTransformation)datasetTransformations.get(0);
        }
        return SequencesGroupDatasetTransformation.concat((SequencesGroupDatasetTransformation[])datasetTransformations.stream().toArray(SequencesGroupDatasetTransformation[]::new));
    }

    public boolean isRemoveNonMultipleOfThree() {
        return this.removeNonMultipleOfThree;
    }

    public void setRemoveNonMultipleOfThree(boolean removeNonMultipleOfThree) {
        if (this.removeNonMultipleOfThree != removeNonMultipleOfThree) {
            boolean oldValue = this.removeNonMultipleOfThree;
            this.removeNonMultipleOfThree = removeNonMultipleOfThree;
            this.fireTransformationsConfigurationModelEvent(FilteringConfigurationEventType.REMOVE_NON_MULTIPLE_OF_THREE_CHANGED, oldValue, this.removeNonMultipleOfThree);
        }
    }

    public boolean isRemoveIfInFrameStopCodon() {
        return this.removeIfInFrameStopCodon;
    }

    public void setRemoveIfInFrameStopCodon(boolean removeIfInFrameStopCodon) {
        if (this.removeIfInFrameStopCodon != removeIfInFrameStopCodon) {
            boolean oldValue = this.removeIfInFrameStopCodon;
            this.removeIfInFrameStopCodon = removeIfInFrameStopCodon;
            this.fireTransformationsConfigurationModelEvent(FilteringConfigurationEventType.REMOVE_IF_IN_FRAME_STOP_CODON_CHANGED, oldValue, this.removeIfInFrameStopCodon);
        }
    }

    public int getReferenceIndex() {
        return this.referenceIndex;
    }

    public void setReferenceIndex(int referenceIndex) {
        if (this.referenceIndex != referenceIndex) {
            int oldValue = this.referenceIndex;
            this.referenceIndex = referenceIndex;
            this.fireTransformationsConfigurationModelEvent(FilteringConfigurationEventType.REFERENCE_INDEX_CHANGED, oldValue, this.referenceIndex);
        }
    }

    public void clearReferenceFile() {
        File oldValue = this.referenceFile;
        this.referenceFile = null;
        this.fireTransformationsConfigurationModelEvent(FilteringConfigurationEventType.REFERENCE_FILE_CHANGED, oldValue, this.referenceFile);
    }

    public void setReferenceFile(File referenceFile) {
        if (this.referenceFile != referenceFile && FilteringConfigurationTransformationProvider.isValidReferenceFile(referenceFile)) {
            File oldValue = this.referenceFile;
            this.referenceFile = referenceFile;
            this.fireTransformationsConfigurationModelEvent(FilteringConfigurationEventType.REFERENCE_FILE_CHANGED, oldValue, this.referenceFile);
        }
    }

    public Optional<File> getReferenceFile() {
        return Optional.ofNullable(this.referenceFile);
    }

    public int getMinNumOfSequences() {
        return this.minNumOfSequences;
    }

    public void setMinNumOfSequences(int minNumOfSequences) {
        if (this.minNumOfSequences != minNumOfSequences) {
            int oldValue = this.minNumOfSequences;
            this.minNumOfSequences = minNumOfSequences;
            this.fireTransformationsConfigurationModelEvent(FilteringConfigurationEventType.MIN_NUM_OF_SEQUENCES_CHANGED, oldValue, this.minNumOfSequences);
        }
    }

    public int getMaxNumOfSequences() {
        return this.maxNumOfSequences;
    }

    public void setMaxNumOfSequences(int maxNumOfSequences) {
        if (this.maxNumOfSequences != maxNumOfSequences) {
            int oldValue = this.maxNumOfSequences;
            this.maxNumOfSequences = maxNumOfSequences;
            this.fireTransformationsConfigurationModelEvent(FilteringConfigurationEventType.MAX_NUM_OF_SEQUENCES_CHANGED, oldValue, this.maxNumOfSequences);
        }
    }

    public int getMinSequenceLength() {
        return this.minSequenceLength;
    }

    public void setMinSequenceLength(int minSequenceLength) {
        if (this.minSequenceLength != minSequenceLength) {
            int oldValue = this.minSequenceLength;
            this.minSequenceLength = minSequenceLength;
            this.fireTransformationsConfigurationModelEvent(FilteringConfigurationEventType.MIN_SEQUENCE_LENGTH_CHANGED, oldValue, this.minSequenceLength);
        }
    }

    public int getMaxSequenceLength() {
        return this.maxSequenceLength;
    }

    public void setMaxSequenceLength(int maxSequenceLength) {
        if (this.maxSequenceLength != maxSequenceLength) {
            int oldValue = this.maxSequenceLength;
            this.maxSequenceLength = maxSequenceLength;
            this.fireTransformationsConfigurationModelEvent(FilteringConfigurationEventType.MAX_SEQUENCE_LENGTH_CHANGED, oldValue, this.maxSequenceLength);
        }
    }

    public boolean hasStartingCodon(String codon) {
        return this.startingCodons.contains(codon);
    }

    public void addStartingCodon(String codon) {
        if (this.startingCodons.add(codon)) {
            this.fireTransformationsConfigurationModelEvent(FilteringConfigurationEventType.STARTING_CODON_ADDED, codon);
        }
    }

    public void removeStartingCodon(String codon) {
        if (this.startingCodons.remove(codon)) {
            this.fireTransformationsConfigurationModelEvent(FilteringConfigurationEventType.STARTING_CODON_REMOVED, codon);
        }
    }

    public Stream<String> getStartingCodons() {
        return this.startingCodons.stream();
    }

    public boolean isRemoveBySizeDifference() {
        return this.removeBySizeDifference;
    }

    public void setRemoveBySizeDifference(boolean removeBySizeDifference) {
        if (this.removeBySizeDifference != removeBySizeDifference) {
            boolean oldValue = this.removeBySizeDifference;
            this.removeBySizeDifference = removeBySizeDifference;
            this.fireTransformationsConfigurationModelEvent(FilteringConfigurationEventType.REMOVE_BY_SIZE_DIFFERENCE_CHANGED, oldValue, this.removeBySizeDifference);
        }
    }

    public int getSizeDifference() {
        return this.sizeDifference;
    }

    public void setSizeDifference(int sizeDifference) {
        if (this.sizeDifference != sizeDifference) {
            int oldValue = this.sizeDifference;
            this.sizeDifference = sizeDifference;
            this.fireTransformationsConfigurationModelEvent(FilteringConfigurationEventType.SIZE_DIFFERENCE_CHANGED, oldValue, this.sizeDifference);
        }
    }

    public HeaderFilteringConfiguration getHeaderFilteringConfiguration() {
        return this.headerFilteringConfiguration;
    }

    public void setHeaderFilteringConfiguration(HeaderFilteringConfiguration headerFilteringConfiguration) {
        if (!this.headerFilteringConfiguration.equals(headerFilteringConfiguration)) {
            HeaderFilteringConfiguration oldValue = this.headerFilteringConfiguration;
            this.headerFilteringConfiguration = headerFilteringConfiguration;
            this.fireTransformationsConfigurationModelEvent(FilteringConfigurationEventType.HEADER_FILTERING_CONFIGURATION_CHANGED, oldValue, this.headerFilteringConfiguration);
        }
    }

    @Override
    public Validation validate() {
        ArrayList<String> errorList = new ArrayList<String>();
        if (!this.startingCodons.stream().allMatch(s -> s.matches(VALID_CODON_CHAR_REGEX))) {
            errorList.add("Invalid starting codon: " + this.startingCodons.stream().filter(c -> !c.matches(VALID_CODON_CHAR_REGEX)).collect(Collectors.joining(", ")));
        }
        if (!this.isValidSequenceLengthConfiguration()) {
            errorList.add("Sequence length configuration is not valid");
        }
        if (!this.isValidNumberOfSequencesConfiguration()) {
            errorList.add("Number of sequences configuration is not valid");
        }
        if (!this.isValidReferenceSequenceConfiguration()) {
            errorList.add("Reference sequence configuration is not valid");
        }
        errorList.addAll(this.headerFilteringConfiguration.validate().getValidationErrors());
        if (errorList.isEmpty()) {
            return new DefaultValidation(new String[0]);
        }
        return new DefaultValidation(errorList);
    }

    public boolean isValidSequenceLengthConfiguration() {
        return this.maxSequenceLength == 0 || this.minSequenceLength <= this.maxSequenceLength;
    }

    public boolean isValidNumberOfSequencesConfiguration() {
        return this.maxNumOfSequences == 0 || this.minNumOfSequences <= this.maxNumOfSequences;
    }

    public boolean isValidHeaderFilteringConfiguration() {
        return this.headerFilteringConfiguration.validate().isValid();
    }

    public boolean isValidReferenceSequenceConfiguration() {
        return this.referenceFile == null || this.isValidReferenceFile();
    }

    public boolean isValidReferenceFile() {
        return FilteringConfigurationTransformationProvider.isValidReferenceFile(this.referenceFile);
    }

    public static boolean isValidReferenceFile(File referenceFile) {
        return referenceFile != null && FilteringConfigurationTransformationProvider.getReferenceSequence(referenceFile).isPresent();
    }

    private static Optional<Sequence> getReferenceSequence(File referenceFile) {
        return FilteringConfigurationTransformationProvider.getReferenceSequence(DatatypeFactory.getDefaultDatatypeFactory(), referenceFile);
    }

    private Optional<Sequence> getReferenceSequence(DatatypeFactory factory) {
        return FilteringConfigurationTransformationProvider.getReferenceSequence(factory, this.referenceFile);
    }

    private static Optional<Sequence> getReferenceSequence(DatatypeFactory factory, File referenceFile) {
        try {
            return factory.newSequencesGroup(referenceFile.toPath()).getSequences().findFirst();
        }
        catch (RuntimeException e) {
            return Optional.empty();
        }
    }
}

