/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.dataset;

import java.util.Map;
import java.util.function.Function;
import org.sing_group.seda.core.filtering.HeaderMatcher;
import org.sing_group.seda.core.filtering.HeaderMatcherCount;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.SequencesGroupDataset;
import org.sing_group.seda.transformation.TransformationException;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;

public class HeaderCountFilteringSequencesGroupDatasetTransformation
implements SequencesGroupDatasetTransformation {
    private final Function<SequencesGroup[], SequencesGroupDataset> builder = factory::newSequencesGroupDataset;
    private int min;
    private HeaderMatcher matcher;
    private int max;
    private boolean include;

    public HeaderCountFilteringSequencesGroupDatasetTransformation(HeaderMatcher matcher, int min, int max, boolean include) {
        this(DatatypeFactory.getDefaultDatatypeFactory(), matcher, min, max, include);
    }

    public HeaderCountFilteringSequencesGroupDatasetTransformation(DatatypeFactory factory, HeaderMatcher matcher, int min, int max, boolean include) {
        this.matcher = matcher;
        this.min = min;
        this.max = max;
        this.include = include;
    }

    @Override
    public SequencesGroupDataset transform(SequencesGroupDataset dataset) {
        SequencesGroup[] sequencesGroups = (SequencesGroup[])dataset.getSequencesGroups().filter(sequenceGroup -> {
            Map<String, Integer> counts = new HeaderMatcherCount(this.matcher).count((SequencesGroup)sequenceGroup);
            boolean invalid = counts.isEmpty() ? true : counts.values().stream().filter(count -> count < this.min || count > this.max).findAny().isPresent();
            if (this.include) {
                return !invalid;
            }
            return invalid;
        }).toArray(SequencesGroup[]::new);
        if (sequencesGroups.length == 0) {
            throw new TransformationException("No sequences after filtering");
        }
        return this.builder.apply(sequencesGroups);
    }
}

