/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.plugin.core.gui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.core.io.JsonObjectWriter;
import org.sing_group.seda.gui.configuration_panel.split.SplitConfigurationPanel;
import org.sing_group.seda.plugin.core.gui.AbstractSedaGuiPlugin;
import org.sing_group.seda.plugin.core.info.plugin.SplitSedaPluginInfo;
import org.sing_group.seda.plugin.spi.TransformationProvider;
import org.sing_group.seda.transformation.provider.split.SplitConfigurationTransformationProvider;

public class SplitSedaGuiPlugin
extends AbstractSedaGuiPlugin {
    private final SplitConfigurationPanel panel = new SplitConfigurationPanel();

    @Override
    public String getName() {
        return "Split";
    }

    @Override
    public String getGroupName() {
        return SplitSedaPluginInfo.GROUP;
    }

    @Override
    public String getDescription() {
        return "Split each input FASTA file into several FASTA files (with the possibilty of random sequence sampling).";
    }

    @Override
    public Component getEditor() {
        return this.panel;
    }

    @Override
    public TransformationProvider getTransformation() {
        return this.panel.getTransformationProvider();
    }

    @Override
    public boolean canSaveTransformation() {
        return true;
    }

    @Override
    public void saveTransformation(File file) throws IOException {
        new JsonObjectWriter<SplitConfigurationTransformationProvider>().write(this.panel.getTransformationProvider(), file);
    }

    @Override
    public void loadTransformation(File file) throws IOException {
        this.panel.setTransformationProvider((SplitConfigurationTransformationProvider)new JsonObjectReader().read(file, SplitConfigurationTransformationProvider.class));
    }
}

