/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.plugin.core.gui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.core.io.JsonObjectWriter;
import org.sing_group.seda.gui.configuration_panel.ncbi.NcbiRenameConfigurationPanel;
import org.sing_group.seda.plugin.core.gui.AbstractSedaGuiPlugin;
import org.sing_group.seda.plugin.core.info.plugin.NcbiRenameSedaPluginInfo;
import org.sing_group.seda.plugin.spi.TransformationProvider;
import org.sing_group.seda.transformation.provider.ncbi.NcbiRenameTransformationProvider;

public class NcbiRenameSedaGuiPlugin
extends AbstractSedaGuiPlugin {
    private final NcbiRenameConfigurationPanel panel = new NcbiRenameConfigurationPanel();

    @Override
    public String getName() {
        return "NCBI Rename";
    }

    @Override
    public String getGroupName() {
        return NcbiRenameSedaPluginInfo.GROUP;
    }

    @Override
    public String getDescription() {
        return "Modify sequence headers and/or file names replacing NCBI accession numbers with organism names and additional information from the NCBI Taxonomy Browser.";
    }

    @Override
    public Component getEditor() {
        return this.panel;
    }

    @Override
    public TransformationProvider getTransformation() {
        return this.panel.getTransformationProvider();
    }

    @Override
    public Optional<String> getProcessDatasetButtonTooltipMessage() {
        return this.panel.getTransformationProvider().getGenerateButtonTooltipMessage();
    }

    @Override
    public boolean canSaveTransformation() {
        return true;
    }

    @Override
    public void saveTransformation(File file) throws IOException {
        new JsonObjectWriter<NcbiRenameTransformationProvider>().write(this.panel.getTransformationProvider(), file);
    }

    @Override
    public void loadTransformation(File file) throws IOException {
        this.panel.setTransformationProvider((NcbiRenameTransformationProvider)new JsonObjectReader().read(file, NcbiRenameTransformationProvider.class));
    }
}

