/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequenceCase;
import org.sing_group.seda.datatype.SequencesGroup;

public final class FastaWriter {
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    private FastaWriter() {
    }

    public static void writeFasta(Path file, Sequence ... sequences) {
        FastaWriter.writeFasta(file, null, false, sequences);
    }

    public static void writeFasta(Path file, boolean gzip, Sequence ... sequences) {
        FastaWriter.writeFasta(file, null, gzip, sequences);
    }

    public static void writeFasta(Path file, Charset charset, boolean gzip, Sequence ... sequences) {
        FastaWriter.writeFasta(file, null, gzip, Arrays.stream(sequences));
    }

    public static void writeFasta(Path file, Stream<Sequence> sequences) {
        FastaWriter.writeFasta(file, null, false, sequences);
    }

    public static void writeFasta(Path file, boolean gzip, Stream<Sequence> sequences) {
        FastaWriter.writeFasta(file, null, gzip, sequences);
    }

    public static void writeFasta(Path file, Charset charset, boolean gzip, Stream<Sequence> sequences) {
        FastaWriter.writeFasta(file, charset, gzip, sequences, SequencesGroup.DEFAULT_LINE_BREAK_OS);
    }

    public static void writeFasta(Path file, boolean gzip, Stream<Sequence> sequences, String lineBreak) {
        FastaWriter.writeFasta(file, null, gzip, sequences, lineBreak);
    }

    public static void writeFasta(Path file, Charset charset, boolean gzip, Stream<Sequence> sequences, String lineBreak) {
        OutputStream output;
        if (charset == null) {
            charset = DEFAULT_CHARSET;
        }
        try {
            output = Files.newOutputStream(file, new OpenOption[0]);
            if (gzip) {
                output = new GZIPOutputStream(output);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected error creating the output file.", e);
        }
        try (OutputStreamWriter fileWriter = new OutputStreamWriter(output, charset);){
            sequences.forEach(sequence -> {
                try {
                    fileWriter.write(FastaWriter.getSequenceHeader(sequence));
                    fileWriter.write(lineBreak);
                    fileWriter.write(FastaWriter.formatSequenceChain(sequence, lineBreak));
                    fileWriter.write(lineBreak);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unexpected error creating the output file.", e);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected error creating the output file.", e);
        }
    }

    private static String getSequenceHeader(Sequence sequence) {
        return ">" + sequence.getName() + (sequence.getDescription().isEmpty() ? "" : " " + sequence.getDescription());
    }

    private static String formatSequenceChain(Sequence sequence, String lineBreak) {
        Optional sequenceCase = sequence.getProperty("case");
        String sequenceChain = sequenceCase.isPresent() && !((SequenceCase)((Object)sequenceCase.get())).equals((Object)SequenceCase.ORIGINAL) ? (((SequenceCase)((Object)sequenceCase.get())).equals((Object)SequenceCase.LOWERCASE) ? sequence.getChain().toLowerCase() : sequence.getChain().toUpperCase()) : sequence.getChain();
        Optional columns = sequence.getProperty("chain.columns");
        if (columns.isPresent()) {
            return FastaWriter.getParts(sequenceChain, (Integer)columns.get()).stream().collect(Collectors.joining(lineBreak));
        }
        return sequenceChain;
    }

    private static List<String> getParts(String string, int partitionSize) {
        ArrayList<String> parts = new ArrayList<String>();
        int len = string.length();
        for (int i = 0; i < len; i += partitionSize) {
            parts.add(string.substring(i, Math.min(len, i + partitionSize)));
        }
        return parts;
    }
}

