/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.io;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.SequencesGroupDataset;
import org.sing_group.seda.io.DatasetProcessorConfiguration;
import org.sing_group.seda.io.FastaWriter;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;

public class DatasetProcessor {
    private final DatatypeFactory factory;

    public DatasetProcessor(DatatypeFactory factory) {
        this.factory = factory;
    }

    public void process(Path[] inputs, Path output, SequencesGroupDatasetTransformation transformation, DatasetProcessorConfiguration configuration) throws IOException {
        this.process(Arrays.stream(inputs), output, transformation, configuration);
    }

    public void process(Path inputDirectory, Path output, SequencesGroupDatasetTransformation transformation, DatasetProcessorConfiguration configuration) throws IOException {
        this.process(DatasetProcessor.findSequencesGroupFiles(inputDirectory), output, transformation, configuration);
    }

    public void process(Stream<Path> inputs, Path output, SequencesGroupDatasetTransformation transformation, DatasetProcessorConfiguration configuration) throws IOException {
        int groupSize = configuration.getGroupSize();
        boolean gzipOutput = configuration.isGzipOutput();
        try (Stream<Path> sequenceFiles = inputs;){
            SequencesGroup[] sequences = (SequencesGroup[])sequenceFiles.map(this.factory::newSequencesGroup).toArray(SequencesGroup[]::new);
            SequencesGroupDataset dataset = transformation.transform(this.factory.newSequencesGroupDataset(sequences));
            SequencesGroup[] sequencesGroups = (SequencesGroup[])dataset.getSequencesGroups().toArray(SequencesGroup[]::new);
            Namer namer = new Namer();
            int count = 0;
            Path groupOutput = output;
            for (SequencesGroup sequencesGroup : sequencesGroups) {
                if (groupSize >= 1 && count % groupSize == 0) {
                    groupOutput = output.resolve("group" + (count / groupSize + 1));
                    Files.createDirectories(groupOutput, new FileAttribute[0]);
                    namer.clearNames();
                }
                StringBuilder name = new StringBuilder(namer.uniqueName(sequencesGroup.getName()));
                if (gzipOutput && !name.toString().endsWith("gz") && !name.toString().endsWith("gzip")) {
                    name.append(".gz");
                }
                FastaWriter.writeFasta(groupOutput.resolve(name.toString()), gzipOutput, sequencesGroup.getSequences(), this.getLineBreakType(sequencesGroup));
                ++count;
            }
        }
    }

    private String getLineBreakType(SequencesGroup sequencesGroup) {
        return sequencesGroup.getProperty("sequence.group.linebreak").orElse(SequencesGroup.DEFAULT_LINE_BREAK_OS);
    }

    private static String composeName(String name, int count) {
        if (name.contains(".")) {
            int dotIndex = name.lastIndexOf(46);
            if (dotIndex == name.length() - 1) {
                return name + "_" + count;
            }
            String filename = name.substring(0, dotIndex);
            String extension = name.substring(dotIndex + 1);
            return filename + "_" + count + "." + extension;
        }
        return name + "_" + count;
    }

    protected static Stream<Path> findSequencesGroupFiles(Path input) throws IOException {
        return Files.find(input, Integer.MAX_VALUE, (file, attrs) -> attrs.isRegularFile() && file.getFileName().toString().toLowerCase().endsWith("fasta"), FileVisitOption.FOLLOW_LINKS);
    }

    private static class Namer {
        private final Set<String> names = new HashSet<String>();

        public void clearNames() {
            this.names.clear();
        }

        public String uniqueName(String name) {
            name = name.replaceAll(".gz$|.gzip$", "");
            int i = 1;
            String uniqueName = name;
            while (this.names.contains(uniqueName)) {
                uniqueName = DatasetProcessor.composeName(name, i++);
            }
            this.names.add(uniqueName);
            return uniqueName;
        }
    }
}

