/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel.ncbi;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.LinkedList;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.JXTextField;
import org.sing_group.gc4s.event.DocumentAdapter;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.seda.plugin.core.info.plugin.NcbiRenameSedaPluginInfo;
import org.sing_group.seda.transformation.dataset.MapRenameSequencesGroupDatasetTransformation;

public class FileRenameConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_POSITION = "seda.filerenameconfiguration.position";
    public static final String PROPERTY_DELIMITER = "seda.filerenameconfiguration.delimiter";
    private static final String HELP_POSITION = NcbiRenameSedaPluginInfo.PARAM_FILE_POSITION_HELP_GUI;
    private static final String HELP_DELIMITER = NcbiRenameSedaPluginInfo.PARAM_FILE_DELIMITER_HELP_GUI;
    private JComboBox<MapRenameSequencesGroupDatasetTransformation.RenameMode> positionCombo;
    private JXTextField delimiterTextField;

    public FileRenameConfigurationPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add(this.getParametersPanel(), "Center");
        this.checkDelimiterStatus();
    }

    private Component getParametersPanel() {
        return new InputParametersPanel(this.getParameters());
    }

    private InputParameter[] getParameters() {
        LinkedList<InputParameter> parameters = new LinkedList<InputParameter>();
        parameters.add(this.getPositionParameter());
        parameters.add(this.getDelimiterParameter());
        return parameters.toArray(new InputParameter[parameters.size()]);
    }

    private InputParameter getPositionParameter() {
        this.positionCombo = new JComboBox<MapRenameSequencesGroupDatasetTransformation.RenameMode>(MapRenameSequencesGroupDatasetTransformation.RenameMode.values());
        this.positionCombo.addItemListener(this::positionChanged);
        return new InputParameter("Position:", this.positionCombo, HELP_POSITION);
    }

    private void positionChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.firePropertyChange(PROPERTY_POSITION, null, (Object)this.getPosition());
            this.checkDelimiterStatus();
        }
    }

    private void checkDelimiterStatus() {
        MapRenameSequencesGroupDatasetTransformation.RenameMode position = this.getPosition();
        boolean enabled = position.equals((Object)MapRenameSequencesGroupDatasetTransformation.RenameMode.PREFIX) || position.equals((Object)MapRenameSequencesGroupDatasetTransformation.RenameMode.SUFFIX);
        this.delimiterTextField.setEnabled(enabled);
    }

    public MapRenameSequencesGroupDatasetTransformation.RenameMode getPosition() {
        return (MapRenameSequencesGroupDatasetTransformation.RenameMode)((Object)this.positionCombo.getSelectedItem());
    }

    private InputParameter getDelimiterParameter() {
        this.delimiterTextField = new JXTextField("Delimiter");
        this.delimiterTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void removeUpdate(DocumentEvent e) {
                this.documentChanged();
            }

            public void insertUpdate(DocumentEvent e) {
                this.documentChanged();
            }

            private void documentChanged() {
                SwingUtilities.invokeLater(() -> FileRenameConfigurationPanel.this.delimiterChanged());
            }
        });
        return new InputParameter("Delimiter:", (JComponent)this.delimiterTextField, HELP_DELIMITER);
    }

    private void delimiterChanged() {
        this.firePropertyChange(PROPERTY_DELIMITER, null, this.getDelimiter());
    }

    public String getDelimiter() {
        return this.delimiterTextField.getText();
    }

    public void setPosition(MapRenameSequencesGroupDatasetTransformation.RenameMode newPosition) {
        this.positionCombo.setSelectedItem((Object)newPosition);
    }

    public void setDelimiter(String newDelimiter) {
        this.delimiterTextField.setText(newDelimiter);
    }
}

