/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.sing_group.seda.gui.OutputConfigurationModelEvent;
import org.sing_group.seda.gui.OutputConfigurationModelListener;

public class OutputConfigurationModel {
    public static final boolean DEFAULT_IN_MEMORY_PROCESSING = true;
    public static final boolean DEFAULT_WRITE_GZIP = false;
    private Path outputDirectory = Paths.get(this.getInitialOutputDirectory(), new String[0]).toAbsolutePath();
    private boolean splitInSubdirectories = false;
    private boolean inMemoryProcessingEnabled = true;
    private int subdirectorySize = 40;
    private boolean writeGzip = false;
    private final List<OutputConfigurationModelListener> listeners = new CopyOnWriteArrayList<OutputConfigurationModelListener>();

    private String getInitialOutputDirectory() {
        return System.getProperty("seda.output.directory", System.getProperty("user.home"));
    }

    public String getOutputDirectoryPath() {
        return this.outputDirectory.toAbsolutePath().toString();
    }

    public Path getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(Path outputDirectory) {
        Objects.requireNonNull(outputDirectory);
        if (!outputDirectory.isAbsolute()) {
            outputDirectory = outputDirectory.toAbsolutePath();
        }
        if (!this.outputDirectory.equals(outputDirectory)) {
            this.outputDirectory = outputDirectory;
            this.fireOutputConfigurationModelEvent(OutputConfigurationModelEvent.of(OutputConfigurationModelEvent.OutputConfigurationModelEventType.OUTPUT_DIRECTORY_CHANGED, this.outputDirectory));
        }
    }

    public boolean isSplitInSubdirectories() {
        return this.splitInSubdirectories;
    }

    public void setSplitInSubdirectories(boolean splitInSubdirectories) {
        if (this.splitInSubdirectories != splitInSubdirectories) {
            this.splitInSubdirectories = splitInSubdirectories;
            this.fireOutputConfigurationModelEvent(OutputConfigurationModelEvent.of(OutputConfigurationModelEvent.OutputConfigurationModelEventType.SPLIT_INTO_SUBDIRECTORIES_CHANGED, this.splitInSubdirectories));
        }
    }

    public int getSubdirectorySize() {
        return this.subdirectorySize;
    }

    public void setSubdirectorySize(int subdirectorySize) {
        if (this.subdirectorySize != subdirectorySize) {
            this.subdirectorySize = subdirectorySize;
            this.fireOutputConfigurationModelEvent(OutputConfigurationModelEvent.of(OutputConfigurationModelEvent.OutputConfigurationModelEventType.SUBDIRECTORIES_SIZE_CHANGED, this.subdirectorySize));
        }
    }

    public boolean isInMemoryProcessingEnabled() {
        return this.inMemoryProcessingEnabled;
    }

    public void setInMemoryProcessingEnabled(boolean inMemoryProcessingEnabled) {
        if (this.inMemoryProcessingEnabled != inMemoryProcessingEnabled) {
            this.inMemoryProcessingEnabled = inMemoryProcessingEnabled;
            this.fireOutputConfigurationModelEvent(OutputConfigurationModelEvent.of(OutputConfigurationModelEvent.OutputConfigurationModelEventType.IN_MEMORY_PROCESSING_ENABLED, this.inMemoryProcessingEnabled));
        }
    }

    public boolean isWriteGzip() {
        return this.writeGzip;
    }

    public void setWriteGzip(boolean writeGzip) {
        if (this.writeGzip != writeGzip) {
            this.writeGzip = writeGzip;
            this.fireOutputConfigurationModelEvent(OutputConfigurationModelEvent.of(OutputConfigurationModelEvent.OutputConfigurationModelEventType.WRITE_GZIP, this.inMemoryProcessingEnabled));
        }
    }

    public void addOutputConfigurationModelListener(OutputConfigurationModelListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public boolean removeOutputConfigurationModelListener(OutputConfigurationModelListener listener) {
        return this.listeners.remove(listener);
    }

    public boolean containsOutputConfigurationModelListener(OutputConfigurationModelListener listener) {
        return this.listeners.contains(listener);
    }

    private void fireOutputConfigurationModelEvent(OutputConfigurationModelEvent event) {
        this.listeners.forEach(listener -> listener.configurationChanged(event));
    }
}

