/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.datatype;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.sing_group.seda.datatype.InMemorySequence;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.io.FastaReader;
import org.sing_group.seda.io.LineBreakType;

public class InMemorySequencesGroup
implements SequencesGroup,
Serializable {
    private static final FastaReader.SequenceFromTextBuilder SEQUENCE_BUILDER = info -> new InMemorySequence(info.getName(), info.getDescription(), info.getChain(), info.getProperties());
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Sequence[] sequences;
    private Map<String, Object> properties;

    public InMemorySequencesGroup(Path file) {
        this(file, null);
    }

    public InMemorySequencesGroup(Path file, Charset charset) {
        this(file.getFileName().toString(), file, charset);
    }

    public InMemorySequencesGroup(String name, Path file) {
        this(name, file, null);
    }

    public InMemorySequencesGroup(String name, Path file, Charset charset) {
        if (!Files.isRegularFile(file, new LinkOption[0]) && !Files.isReadable(file)) {
            throw new IllegalArgumentException("file should be a regular and readable file");
        }
        this.name = name;
        this.sequences = (Sequence[])FastaReader.readFasta(file, charset, SEQUENCE_BUILDER).toArray(Sequence[]::new);
        this.properties = new HashMap<String, Object>();
        if (this.sequences.length > 0) {
            LineBreakType lineBreakType = LineBreakType.forFile(file);
            if (!this.properties.containsKey("sequence.group.linebreak") && !lineBreakType.equals((Object)LineBreakType.defaultType())) {
                this.properties.put("sequence.group.linebreak", lineBreakType.getLineBreak());
            }
        }
    }

    public InMemorySequencesGroup(String name, Sequence ... sequences) {
        this(name, Collections.emptyMap(), sequences);
    }

    public InMemorySequencesGroup(String name, Map<String, Object> properties, Sequence ... sequences) {
        this.name = name;
        this.properties = properties;
        this.sequences = sequences;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Stream<Sequence> getSequences() {
        return Arrays.stream(this.sequences);
    }

    @Override
    public int getSequenceCount() {
        return this.sequences.length;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + Arrays.hashCode(this.sequences);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InMemorySequencesGroup other = (InMemorySequencesGroup)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        return Arrays.equals(this.sequences, other.sequences);
    }
}

