/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.datatype;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.io.FastaWriter;

public class InDiskSequence
implements Sequence {
    private final Path file;
    private final Charset charset;
    private final boolean isTempFile;
    private final long nameLocation;
    private final int nameLength;
    private final long descriptionLocation;
    private final int descriptionLength;
    private final long headerLocation;
    private final int headerLength;
    private final long chainLocation;
    private final int chainLength;
    private final Map<String, Object> properties;

    public InDiskSequence(Path file, Charset charset, long nameLocation, int nameLength, long descriptionLocation, int descriptionLength, long headerLocation, int headerLength, long chainLocation, int chainLength, Map<String, Object> properties) {
        this.file = file;
        this.charset = charset;
        this.isTempFile = false;
        this.nameLocation = nameLocation;
        this.nameLength = nameLength;
        this.descriptionLocation = descriptionLocation;
        this.descriptionLength = descriptionLength;
        this.headerLocation = headerLocation;
        this.headerLength = headerLength;
        this.chainLocation = chainLocation;
        this.chainLength = chainLength;
        this.properties = new HashMap<String, Object>(properties);
    }

    public InDiskSequence(Sequence sequence) {
        this(sequence.getName(), sequence.getDescription(), sequence.getChain(), sequence.getProperties());
    }

    public InDiskSequence(String name, String description, String sequence, Map<String, Object> properties) {
        try {
            this.file = Files.createTempFile("seda_", "seq.fasta", new FileAttribute[0]);
            this.charset = Charset.defaultCharset();
            this.file.toFile().deleteOnExit();
            this.isTempFile = true;
            FastaWriter.writeFasta(this.file, Sequence.of(name, description, sequence));
            this.headerLocation = 0L;
            this.nameLocation = 1L;
            this.nameLength = name.getBytes().length;
            if (description != null && !description.isEmpty()) {
                this.descriptionLocation = this.nameLocation + (long)this.nameLength + 1L;
                this.descriptionLength = description.getBytes().length;
                this.headerLength = (int)this.descriptionLocation + this.descriptionLength;
            } else {
                this.descriptionLocation = -1L;
                this.descriptionLength = -1;
                this.headerLength = (int)this.nameLocation + this.nameLength;
            }
            this.chainLocation = this.headerLocation + (long)this.headerLength + 1L;
            this.chainLength = sequence.getBytes().length;
            this.properties = new HashMap<String, Object>(properties);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected error creating temporary file.", e);
        }
    }

    private String readFromFile(long location, int length) {
        String string;
        RandomAccessFile rac = new RandomAccessFile(this.file.toFile(), "r");
        try {
            rac.seek(location);
            byte[] bytes = new byte[length];
            rac.readFully(bytes, 0, bytes.length);
            string = this.charset == null ? new String(bytes) : new String(bytes, this.charset);
        }
        catch (Throwable throwable) {
            try {
                try {
                    rac.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error reading sequence file", ioe);
            }
        }
        rac.close();
        return string;
    }

    public Path getFile() {
        return this.file;
    }

    @Override
    public String getName() {
        return this.readFromFile(this.nameLocation, this.nameLength).trim();
    }

    @Override
    public String getDescription() {
        if (this.descriptionLocation > 0L) {
            return this.readFromFile(this.descriptionLocation, this.descriptionLength).trim();
        }
        return "";
    }

    @Override
    public String getHeader() {
        return this.readFromFile(this.headerLocation, this.headerLength);
    }

    @Override
    public String getChain() {
        return this.readFromFile(this.chainLocation, this.chainLength).replaceAll("\\s+", "");
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public <T> Optional<T> getProperty(String key) {
        return Optional.ofNullable(this.properties.get(key));
    }

    protected void finalize() throws Throwable {
        if (this.isTempFile) {
            Files.deleteIfExists(this.file);
        }
    }

    public String toString() {
        return this.getHeader() + "\n" + this.getName() + "\n" + this.getDescription() + "\n" + this.getChain();
    }
}

