/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.core.split;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sing_group.seda.core.split.SequencesGroupSplitter;
import org.sing_group.seda.core.split.SequencesSort;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.SequencesGroupBuilder;

public abstract class AbstractSequencesGroupSplitter
implements SequencesGroupSplitter {
    private SequencesSort sequencesSort;
    private final SequencesGroupBuilder builder;

    public AbstractSequencesGroupSplitter(SequencesSort sequencesSort, DatatypeFactory factory) {
        this.sequencesSort = sequencesSort;
        this.builder = factory::newSequencesGroup;
    }

    protected List<Sequence> getInputSequencesGroup(SequencesGroup group) {
        return this.sequencesSort.sort(group.getSequences().collect(Collectors.toList()));
    }

    protected SequencesGroup createGroup(String name, Map<String, Object> properties, List<Sequence> sequences) {
        return this.builder.of(name, properties, sequences);
    }
}

