/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.core.rename;

import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.sing_group.seda.core.rename.EmptySequenceHeadersJoiner;
import org.sing_group.seda.core.rename.HeaderTarget;
import org.sing_group.seda.datatype.Sequence;

@XmlRootElement
@XmlSeeAlso(value={EmptySequenceHeadersJoiner.class})
public class SequenceHeadersJoiner {
    @XmlElement
    private HeaderTarget target;
    @XmlElement
    private CharSequence delimiter;
    @XmlElement
    private CharSequence prefix;
    @XmlElement
    private CharSequence suffix;

    public SequenceHeadersJoiner() {
    }

    public SequenceHeadersJoiner(HeaderTarget target, CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        this.target = target;
        this.delimiter = delimiter;
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public String join(List<Sequence> sequences) {
        return sequences.stream().map(this::mapSequence).collect(Collectors.joining(this.delimiter, this.prefix, this.suffix));
    }

    private String mapSequence(Sequence s) {
        switch (this.target) {
            case ALL: {
                return s.getName() + " " + s.getDescription();
            }
            case NAME: {
                return s.getName();
            }
            case DESCRIPTION: {
                return s.getName();
            }
        }
        throw new IllegalArgumentException("Unknown HeaderTarget value: " + (Object)((Object)this.target));
    }

    public HeaderTarget getTarget() {
        return this.target;
    }

    public CharSequence getDelimiter() {
        return this.delimiter;
    }

    public CharSequence getPrefix() {
        return this.prefix;
    }

    public CharSequence getSuffix() {
        return this.suffix;
    }
}

