/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.core.ncbi.codes;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;

public class NcbiCodonTables {
    private static final String LIST = "list.txt";
    private Map<Integer, String> tablesList;
    private Map<Integer, Map<String, String>> tables = new HashMap<Integer, Map<String, String>>();

    private static InputStream getResource(String resource) {
        return NcbiCodonTables.class.getResourceAsStream(resource);
    }

    public Map<Integer, String> listTables() {
        if (this.tablesList == null) {
            this.loadTables();
        }
        return this.tablesList;
    }

    private void loadTables() {
        this.tablesList = new HashMap<Integer, String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(NcbiCodonTables.getResource(LIST)));){
            br.lines().forEach(line -> {
                String[] split = line.split(Pattern.quote("."));
                this.tablesList.put(Integer.valueOf(split[0]), split[1].trim());
            });
        }
        catch (IOException e) {
            throw new RuntimeException("An error ocurred while reading the tables list");
        }
    }

    public Map<String, String> getCodonTable(Integer tableId) {
        if (!this.tables.containsKey(this.isValidTableId(tableId))) {
            this.loadTable(tableId);
        }
        return this.tables.get(tableId);
    }

    private Integer isValidTableId(Integer tableId) {
        if (!this.listTables().containsKey(tableId)) {
            throw new IllegalArgumentException("The requested table ID (" + tableId + ") does not correspond to a known identifier");
        }
        return tableId;
    }

    private void loadTable(Integer tableId) {
        HashMap<String, String> codonTable = new HashMap<String, String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(NcbiCodonTables.getResource("maps/" + tableId.toString())));){
            br.lines().forEach(line -> {
                String[] split = line.split(Pattern.quote(" "));
                codonTable.put(split[0], split[1]);
            });
            codonTable.put("---", "-");
        }
        catch (IOException e) {
            throw new RuntimeException("An error ocurred while reading the codon table");
        }
        this.tables.put(tableId, codonTable);
    }

    public Optional<Integer> findIdentifier(Map<String, String> standardCodonTable) {
        for (int id : this.listTables().keySet()) {
            if (!standardCodonTable.equals(this.getCodonTable(id))) continue;
            return Optional.of(id);
        }
        return Optional.empty();
    }
}

