/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.core.execution;

import java.util.Set;
import java.util.stream.Collectors;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.core.execution.BinaryCheckingUtils;
import org.sing_group.seda.util.OsUtils;

public class DockerExecutionUtils {
    public static void checkDockerAvailability() throws BinaryCheckException {
        try {
            BinaryCheckingUtils.checkCommand("docker --version", 1);
        }
        catch (BinaryCheckException bce) {
            throw new BinaryCheckException("Error checking docker availability", bce, "docker --version");
        }
    }

    public static String dockerPath(String path) {
        if (OsUtils.isWindows()) {
            return path.replaceAll("^(?i)c:", "/c").replaceAll("\\\\", "/");
        }
        if (OsUtils.isMacOs()) {
            return "/private" + path;
        }
        return path;
    }

    public static String getMountDockerDirectoriesString(Set<String> directoriesToMount) {
        return directoriesToMount.stream().map(d -> "-v " + DockerExecutionUtils.dockerPath(d) + ":" + DockerExecutionUtils.dockerPath(d)).collect(Collectors.joining(" "));
    }
}

