/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cli.parameters;

import es.uvigo.ei.sing.yacli.command.option.DefaultValuedStringOption;
import es.uvigo.ei.sing.yacli.command.option.FlagOption;
import es.uvigo.ei.sing.yacli.command.option.IntegerDefaultValuedStringConstructedOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.util.ArrayList;
import java.util.List;
import org.sing_group.seda.cli.SedaCommand;
import org.sing_group.seda.cli.parameters.HeaderMatcherCliParameters;
import org.sing_group.seda.core.filtering.HeaderFilteringConfiguration;
import org.sing_group.seda.core.filtering.HeaderMatcher;
import org.sing_group.seda.core.filtering.RegexHeaderMatcher;
import org.sing_group.seda.core.rename.HeaderTarget;
import org.sing_group.seda.plugin.core.info.common.HeaderCountFilteringInfo;

public class HeaderCountFilteringCliParameters {
    public static final FlagOption OPTION_USE_FILTER = new FlagOption("use-header-count-filtering", "uhcf", "Filters sequences or files so that only those meeting the specified criteria regarding counts on their headers are kept.");
    public static final DefaultValuedStringOption OPTION_MODE = new DefaultValuedStringOption("header-count-filtering-mode", "hm", HeaderCountFilteringInfo.PARAM_HEADER_MODE_HELP, HeaderFilteringConfiguration.Mode.KEEP.toString().toLowerCase());
    public static final DefaultValuedStringOption OPTION_LEVEL = new DefaultValuedStringOption("header-count-filtering-level", "hl", HeaderCountFilteringInfo.PARAM_HEADER_LEVEL_HELP, HeaderFilteringConfiguration.Level.SEQUENCE.name().toLowerCase());
    public static final IntegerDefaultValuedStringConstructedOption OPTION_RANGE_MIN = new IntegerDefaultValuedStringConstructedOption("header-count-filtering-min", "hmin", "The minimum number of sequences that must contain the specified filter.", Integer.valueOf(0));
    public static final IntegerDefaultValuedStringConstructedOption OPTION_RANGE_MAX = new IntegerDefaultValuedStringConstructedOption("header-count-filtering-max", "hmax", "The maximum number of sequences that must contain the specified filter.", Integer.valueOf(10));
    public static final HeaderMatcherCliParameters OPTIONS_HEADER_MATCHER = new HeaderMatcherCliParameters("header-count-filtering-type", "ht");

    public static List<Option<?>> getOptionList() {
        ArrayList options = new ArrayList();
        options.add((Option<?>)OPTION_USE_FILTER);
        options.add((Option<?>)OPTION_MODE);
        options.add((Option<?>)OPTION_LEVEL);
        options.add((Option<?>)OPTION_RANGE_MIN);
        options.add((Option<?>)OPTION_RANGE_MAX);
        options.addAll(OPTIONS_HEADER_MATCHER.getOptionList());
        return options;
    }

    public static HeaderFilteringConfiguration getHeaderFilteringConfiguration(Parameters parameters) {
        boolean useFilter = parameters.hasFlag((Option)OPTION_USE_FILTER);
        int min = (Integer)parameters.getSingleValue((Option)OPTION_RANGE_MIN);
        int max = (Integer)parameters.getSingleValue((Option)OPTION_RANGE_MAX);
        HeaderFilteringConfiguration.Mode mode = null;
        HeaderFilteringConfiguration.Level level = null;
        HeaderFilteringConfiguration.FilterType filterType = HeaderFilteringConfiguration.FilterType.SEQUENCE_NAME;
        String filterString = null;
        boolean quotePattern = false;
        int regexGroup = 0;
        boolean caseSensitive = false;
        HeaderTarget headerTarget = HeaderTarget.ALL;
        try {
            mode = HeaderFilteringConfiguration.Mode.valueOf(((String)parameters.getSingleValue((Option)OPTION_MODE)).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            SedaCommand.invalidEnumValue(OPTION_MODE);
        }
        try {
            level = HeaderFilteringConfiguration.Level.valueOf(((String)parameters.getSingleValue((Option)OPTION_LEVEL)).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            SedaCommand.invalidEnumValue(OPTION_LEVEL);
        }
        HeaderMatcher hm = OPTIONS_HEADER_MATCHER.getHeaderMatcher(parameters);
        if (hm instanceof RegexHeaderMatcher) {
            RegexHeaderMatcher regexHeaderMatcher = (RegexHeaderMatcher)hm;
            filterString = regexHeaderMatcher.getString();
            quotePattern = regexHeaderMatcher.getRegexConfig().isQuotePattern();
            regexGroup = regexHeaderMatcher.getRegexConfig().getGroup();
            caseSensitive = regexHeaderMatcher.getRegexConfig().isCaseSensitive();
            headerTarget = regexHeaderMatcher.getHeaderTarget();
            filterType = HeaderFilteringConfiguration.FilterType.REGEX;
        }
        return new HeaderFilteringConfiguration(useFilter, mode, level, min, max, filterType, filterString, quotePattern, regexGroup, caseSensitive, headerTarget);
    }
}

