/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cli.command;

import es.uvigo.ei.sing.yacli.command.option.FileOption;
import es.uvigo.ei.sing.yacli.command.option.FlagOption;
import es.uvigo.ei.sing.yacli.command.option.IntegerDefaultValuedStringConstructedOption;
import es.uvigo.ei.sing.yacli.command.option.IntegerOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.option.StringOption;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.sing_group.seda.cli.SedaCommand;
import org.sing_group.seda.cli.parameters.HeaderCountFilteringCliParameters;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.plugin.core.info.plugin.FilteringSedaPluginInfo;
import org.sing_group.seda.plugin.spi.TransformationProvider;
import org.sing_group.seda.transformation.provider.filtering.FilteringConfigurationTransformationProvider;

public class FilteringCommand
extends SedaCommand {
    public static final StringOption OPTION_STARTING_CODON = new StringOption("starting-codon", "sc", "Filters sequences so that only those starting with the selected codons are kept. Combinations of 3 characters using: 'A', 'C', 'T', 'G'. Examples: ATG, CCA, AAA, GCT.", true, true, true);
    public static final FlagOption OPTION_NON_MULTIPLE_3 = new FlagOption("remove-non-multiple-3", "rnm3", "Filters sequences so that only those having a length that is multiple of 3 are kept.");
    public static final FlagOption OPTION_IN_FRAME_STOP_CODONS = new FlagOption("remove-with-in-frame-stop-codons", "rwifsc", "Filters sequences so that only those without in-frame stop codons are kept.");
    public static final IntegerOption OPTION_MINIMUM_SEQUENCE_LENGTH = new IntegerOption("minimum-sequence-length", "minl", "Filters sequences so that only those with the specified minimum sequence length are kept.", true);
    public static final IntegerOption OPTION_MAXIMUM_SEQUENCE_LENGTH = new IntegerOption("maximum-sequence-length", "maxl", "Filters sequences so that only those with the specified maximum sequence length are kept.", true);
    public static final IntegerDefaultValuedStringConstructedOption OPTION_MINIMUM_SEQUENCES = new IntegerDefaultValuedStringConstructedOption("minimum-sequences", "mins", "Filters files so that only those with the specified minimum number of sequences are kept.", Integer.valueOf(1));
    public static final IntegerDefaultValuedStringConstructedOption OPTION_MAXIMUM_SEQUENCES = new IntegerDefaultValuedStringConstructedOption("maximum-sequences", "maxs", "Filters files so that only those with the specified maximum number of sequences are kept.", Integer.valueOf(0));
    public static final FlagOption OPTION_REMOVE_SIZE_DIFFERENCE = new FlagOption("remove-size-difference", "rsd", "Filters sequences so that only those with the specified difference when compared to the reference sequence are kept.");
    public static final IntegerDefaultValuedStringConstructedOption OPTION_MAX_SIZE_DIFFERENCE = new IntegerDefaultValuedStringConstructedOption("max-size-difference", "maxsd", "The maximum sequence length difference allowed expressed as a percentage.", Integer.valueOf(10));
    public static final IntegerDefaultValuedStringConstructedOption OPTION_SEQUENCE_INDEX = new IntegerDefaultValuedStringConstructedOption("reference-sequence-index", "rsi", "The index of the sequence to use as reference to compare others. The first sequence corresponds to index 1. This option is ignored if a reference sequence file is selected.", Integer.valueOf(1));
    public static final FileOption OPTION_SEQUENCE_FILE = new FileOption("reference-sequence-file", "rsf", "The file containing the sequence to use as reference to compare others. If a file is selected, then the reference sequence index is ignored.", true, true);

    public String getName() {
        return "filtering";
    }

    public String getDescriptiveName() {
        return "Filtering";
    }

    public String getDescription() {
        return "Filter sequences based on different criteria (e.g. sequence length, non-multiple of three, or in-frame stop codons presence, among others).";
    }

    @Override
    protected String getSedaGroup() {
        return FilteringSedaPluginInfo.GROUP;
    }

    @Override
    protected List<Option<?>> createSedaOptions() {
        ArrayList options = new ArrayList();
        options.add((Option<?>)OPTION_STARTING_CODON);
        options.add((Option<?>)OPTION_NON_MULTIPLE_3);
        options.add((Option<?>)OPTION_IN_FRAME_STOP_CODONS);
        options.add((Option<?>)OPTION_MINIMUM_SEQUENCE_LENGTH);
        options.add((Option<?>)OPTION_MAXIMUM_SEQUENCE_LENGTH);
        options.add((Option<?>)OPTION_MINIMUM_SEQUENCES);
        options.add((Option<?>)OPTION_MAXIMUM_SEQUENCES);
        options.add((Option<?>)OPTION_REMOVE_SIZE_DIFFERENCE);
        options.add((Option<?>)OPTION_MAX_SIZE_DIFFERENCE);
        options.add((Option<?>)OPTION_SEQUENCE_INDEX);
        options.add((Option<?>)OPTION_SEQUENCE_FILE);
        options.addAll(HeaderCountFilteringCliParameters.getOptionList());
        return options;
    }

    @Override
    protected TransformationProvider getTransformation(Parameters parameters) {
        FilteringConfigurationTransformationProvider provider = new FilteringConfigurationTransformationProvider();
        if (parameters.hasOption((Option)OPTION_STARTING_CODON)) {
            parameters.getAllValues((Option)OPTION_STARTING_CODON).forEach(provider::addStartingCodon);
        }
        if (parameters.hasOption((Option)OPTION_MINIMUM_SEQUENCE_LENGTH)) {
            Integer minSequenceLength = (Integer)parameters.getSingleValue((Option)OPTION_MINIMUM_SEQUENCE_LENGTH);
            if (minSequenceLength <= 0) {
                FilteringCommand.formattedValidationError(FilteringCommand.formatParam(OPTION_MINIMUM_SEQUENCE_LENGTH) + " must be greater than 0.");
            }
            provider.setMinSequenceLength(minSequenceLength);
        }
        if (parameters.hasOption((Option)OPTION_MAXIMUM_SEQUENCE_LENGTH)) {
            Integer maxSequenceLength = (Integer)parameters.getSingleValue((Option)OPTION_MAXIMUM_SEQUENCE_LENGTH);
            if (maxSequenceLength <= 0) {
                FilteringCommand.formattedValidationError(FilteringCommand.formatParam(OPTION_MAXIMUM_SEQUENCE_LENGTH) + " must be greater than 0.");
            }
            provider.setMaxSequenceLength(maxSequenceLength);
        }
        provider.setRemoveNonMultipleOfThree(parameters.hasFlag((Option)OPTION_NON_MULTIPLE_3));
        provider.setRemoveIfInFrameStopCodon(parameters.hasFlag((Option)OPTION_IN_FRAME_STOP_CODONS));
        provider.setMinNumOfSequences((Integer)parameters.getSingleValue((Option)OPTION_MINIMUM_SEQUENCES));
        provider.setMaxNumOfSequences((Integer)parameters.getSingleValue((Option)OPTION_MAXIMUM_SEQUENCES));
        if (parameters.hasFlag((Option)OPTION_REMOVE_SIZE_DIFFERENCE)) {
            provider.setRemoveBySizeDifference(parameters.hasFlag((Option)OPTION_REMOVE_SIZE_DIFFERENCE));
            provider.setSizeDifference((Integer)parameters.getSingleValue((Option)OPTION_MAX_SIZE_DIFFERENCE));
            provider.setReferenceIndex((Integer)parameters.getSingleValue((Option)OPTION_SEQUENCE_INDEX));
            if (parameters.hasOption((Option)OPTION_SEQUENCE_FILE)) {
                File sequenceFile = (File)parameters.getSingleValue((Option)OPTION_SEQUENCE_FILE);
                if (!sequenceFile.isFile()) {
                    FilteringCommand.formattedValidationError("Sequence file does not exist");
                }
                provider.setReferenceFile(sequenceFile);
            }
        }
        try {
            provider.setHeaderFilteringConfiguration(HeaderCountFilteringCliParameters.getHeaderFilteringConfiguration(parameters));
        }
        catch (IllegalArgumentException e) {
            FilteringCommand.formattedValidationError(e.getMessage());
        }
        return provider;
    }

    @Override
    protected TransformationProvider getTransformation(File parametersFile) throws IOException {
        return (TransformationProvider)new JsonObjectReader().read(parametersFile, FilteringConfigurationTransformationProvider.class);
    }
}

