/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.clustalomega.execution;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.sing_group.seda.clustalomega.execution.ClustalOmegaBinariesChecker;
import org.sing_group.seda.clustalomega.execution.ClustalOmegaBinariesExecutor;
import org.sing_group.seda.core.execution.AbstractBinariesExecutor;
import org.sing_group.seda.core.execution.BinaryCheckException;

public abstract class AbstractClustalOmegaBinariesExecutor
extends AbstractBinariesExecutor
implements ClustalOmegaBinariesExecutor {
    @Override
    public void checkBinary() throws BinaryCheckException {
        ClustalOmegaBinariesChecker.checkClustalOmegaBinary(this.getClustalOmegaCommand());
    }

    protected abstract String getClustalOmegaCommand();

    protected abstract String toFilePath(File var1);

    protected void executeAlignment(List<String> clustalCommand, File inputFile, File outputFile, int numThreads, String additionalParameters) throws IOException, InterruptedException {
        LinkedList<String> parameters = new LinkedList<String>(clustalCommand);
        parameters.addAll(Arrays.asList("--threads=" + numThreads, "-i", this.toFilePath(inputFile), "-o", this.toFilePath(outputFile), "--force"));
        if (additionalParameters != null && !additionalParameters.isEmpty()) {
            parameters.addAll(this.getAdditionalParameters(additionalParameters));
        }
        this.executeCommand(parameters);
    }

    private Collection<? extends String> getAdditionalParameters(String additionalParameters) {
        return Arrays.asList(additionalParameters.split(" "));
    }

    @Override
    protected void executeCommand(List<String> parameters) throws IOException, InterruptedException {
        File errorFile = Files.createTempFile("clustal-omega-command-error", ".txt", new FileAttribute[0]).toFile();
        File outputFile = Files.createTempFile("clustal-omega-command-output", ".txt", new FileAttribute[0]).toFile();
        this.executeCommand(parameters, errorFile, outputFile);
    }
}

