/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OnDemandLogger {
    private final Class c;
    private Log _log = null;

    public OnDemandLogger(Class c) {
        this.c = c;
    }

    private Log getLog() {
        if (this.c == null) {
            throw new RuntimeException("Unable to load Logging, Logging class not found");
        }
        if (this._log == null) {
            this._log = LogFactory.getLog((Class)this.c);
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("OnDemandLogger initialized for " + this.c + " is:" + this._log));
            }
        }
        return this._log;
    }

    public void resetLog() {
        if (this._log != null && this._log.isDebugEnabled()) {
            this._log.debug((Object)("OnDemandLogger reset for " + this.c));
        }
        this._log = null;
    }

    public boolean hasLog() {
        return this._log != null;
    }

    public void debug(Object arg0, Throwable arg1) {
        this.getLog().debug(arg0, arg1);
    }

    public void debug(Object arg0) {
        this.getLog().debug(arg0);
    }

    public void error(Object arg0, Throwable arg1) {
        this.getLog().error(arg0, arg1);
    }

    public void error(Object arg0) {
        this.getLog().error(arg0);
    }

    public void fatal(Object arg0, Throwable arg1) {
        this.getLog().fatal(arg0, arg1);
    }

    public void fatal(Object arg0) {
        this.getLog().fatal(arg0);
    }

    public void info(Object arg0, Throwable arg1) {
        this.getLog().info(arg0, arg1);
    }

    public void info(Object arg0) {
        this.getLog().info(arg0);
    }

    public boolean isDebugEnabled() {
        return this.getLog().isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.getLog().isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.getLog().isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        return this.getLog().isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.getLog().isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.getLog().isWarnEnabled();
    }

    public void trace(Object arg0, Throwable arg1) {
        this.getLog().trace(arg0, arg1);
    }

    public void trace(Object arg0) {
        this.getLog().trace(arg0);
    }

    public void warn(Object arg0, Throwable arg1) {
        this.getLog().warn(arg0, arg1);
    }

    public void warn(Object arg0) {
        this.getLog().warn(arg0);
    }
}

