/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.bedtools.execution;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.bedtools.execution.AbstractBedToolsBinariesExecutor;
import org.sing_group.seda.bedtools.execution.BedToolsEnvironment;

@XmlRootElement
public class DefaultBedToolsBinariesExecutor
extends AbstractBedToolsBinariesExecutor {
    @XmlElement
    private final File bedToolsBinary;

    public DefaultBedToolsBinariesExecutor() {
        this(Paths.get(BedToolsEnvironment.getInstance().getBedToolsCommand(), new String[0]).toFile());
    }

    public DefaultBedToolsBinariesExecutor(File bedToolsExecutable) {
        this.bedToolsBinary = bedToolsExecutable;
    }

    @Override
    public void getFasta(File inputFasta, File bedFile, File output, String additionalParameters) throws IOException, InterruptedException {
        super.getFasta(Arrays.asList(this.getBedToolsCommand()), inputFasta, bedFile, output, additionalParameters);
    }

    @Override
    protected String getBedToolsCommand() {
        return this.bedToolsBinary.getPath();
    }

    @Override
    protected String toFilePath(File file) {
        return file.getAbsolutePath();
    }

    public File getBedToolsBinary() {
        return this.bedToolsBinary;
    }
}

