/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.pfam.transformations;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.pfam.PfamScanAnnotations;
import org.sing_group.seda.pfam.PfamScanBatch;
import org.sing_group.seda.pfam.PfamScanBatchResult;
import org.sing_group.seda.pfam.PfamScanRequestConfiguration;
import org.sing_group.seda.pfam.PfamScanSequenceErrorPolicy;
import org.sing_group.seda.transformation.TransformationException;
import org.sing_group.seda.transformation.sequencesgroup.SequencesGroupTransformation;

public class PfamScanSequencesGroupTransformation
implements SequencesGroupTransformation {
    private static final int BATCH_SIZE = 30;
    private PfamScanRequestConfiguration configuration;
    private long firstBatchDuration = -1L;
    private DatatypeFactory factory;

    public PfamScanSequencesGroupTransformation(PfamScanRequestConfiguration configuration) {
        this(configuration, DatatypeFactory.getDefaultDatatypeFactory());
    }

    public PfamScanSequencesGroupTransformation(PfamScanRequestConfiguration configuration, DatatypeFactory factory) {
        this.factory = factory;
        this.configuration = configuration;
    }

    @Override
    public SequencesGroup transform(SequencesGroup sequencesGroup) throws TransformationException {
        List sequences = sequencesGroup.getSequences().collect(Collectors.toList());
        LinkedList<Sequence> annotatedSequences = new LinkedList<Sequence>();
        for (int i = 0; i < sequencesGroup.getSequenceCount(); i += 30) {
            if (this.firstBatchDuration > 0L) {
                try {
                    TimeUnit.NANOSECONDS.sleep(this.firstBatchDuration * (long)this.configuration.getBatchDelayFactor());
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            int start = i;
            int end = Math.min(i + 30, sequencesGroup.getSequenceCount());
            List<Sequence> currentBatch = sequences.subList(start, end);
            long startTime = System.nanoTime();
            PfamScanBatch pfam = new PfamScanBatch(this.configuration, currentBatch);
            try {
                PfamScanBatchResult pfamResults = pfam.query().get();
                if (pfamResults.getFailures().size() > 0 && this.configuration.getErrorPolicy().equals((Object)PfamScanSequenceErrorPolicy.PRODUCE_ERROR)) {
                    throw new TransformationException("The following sequences could not be annotated with PfamScan" + pfamResults.getFailures().stream().map(Sequence::getName).collect(Collectors.joining(", ")));
                }
                for (Sequence sequence : currentBatch) {
                    CharSequence description;
                    if (pfamResults.getAnnotations().containsKey(sequence)) {
                        description = this.getAnnotatedDescription(sequence.getDescription(), pfamResults.getAnnotations().get(sequence));
                        annotatedSequences.add(this.factory.newSequence(sequence.getName(), (String)description, sequence.getChain(), sequence.getProperties()));
                        continue;
                    }
                    if (!this.configuration.getErrorPolicy().equals((Object)PfamScanSequenceErrorPolicy.MARK_ERROR)) continue;
                    description = new StringBuilder(sequence.getDescription());
                    ((StringBuilder)description).append("(PfamScan error)");
                    annotatedSequences.add(this.factory.newSequence(sequence.getName(), ((StringBuilder)description).toString(), sequence.getChain(), sequence.getProperties()));
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new TransformationException(e);
            }
            long endTime = System.nanoTime();
            if (this.firstBatchDuration >= 0L) continue;
            this.firstBatchDuration = endTime - startTime;
        }
        return this.factory.newSequencesGroup(sequencesGroup.getName(), sequencesGroup.getProperties(), annotatedSequences);
    }

    private String getAnnotatedDescription(String sequenceDescription, PfamScanAnnotations pfamScanAnnotations) {
        StringBuilder description = new StringBuilder(sequenceDescription);
        if (!sequenceDescription.isEmpty() && !pfamScanAnnotations.isEmpty()) {
            description.append(" ");
        }
        description.append(pfamScanAnnotations.stream().map(a -> "(" + a.getAlignStart() + "-" + a.getAlignEnd() + " " + a.getHmmAcc() + " " + a.getHmmName() + " - " + a.getType() + ")").collect(Collectors.joining(" ")));
        return description.toString();
    }
}

