/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.pfam.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.sing_group.seda.pfam.PfamScanRequestConfiguration;
import org.sing_group.seda.pfam.PfamScanSequenceErrorPolicy;
import org.sing_group.seda.plugin.core.Group;
import org.sing_group.seda.plugin.core.info.AbstractInfo;

public class PfamScanSedaPluginInfo
extends AbstractInfo {
    public static final String NAME = "PfamScan";
    public static final String SHORT_NAME = "pfamscan";
    public static final String DESCRIPTION = "Search and annotate sequences against the Pfam-A HMM library using the EMBL-EBI web service (https://www.ebi.ac.uk/Tools/pfa/pfamscan/).";
    public static final String GROUP = Group.GROUP_PROTEIN_ANNOTATION.getName();
    public static final String PARAM_EMAIL_NAME = "email";
    public static final String PARAM_EMAIL_SHORT_NAME = "em";
    public static final String PARAM_EMAIL_DESCRIPTION = "E-mail";
    public static final List<String> PARAM_EMAIL_HELP_ITEMS = Arrays.asList("Problems with the service which affect your jobs.", "Scheduled maintenance which affects services you are using.", "Deprecation and retirement of a service you are using");
    public static final String PARAM_EMAIL_HELP_BASE = "A valid e-mail address. This is required by EMBL-EBI so they can contact you in the event of: ";
    public static final String PARAM_EMAIL_HELP = PfamScanSedaPluginInfo.itemsListToCliString(PARAM_EMAIL_HELP_ITEMS, "A valid e-mail address. This is required by EMBL-EBI so they can contact you in the event of: ");
    public static final String PARAM_EMAIL_HELP_GUI = PfamScanSedaPluginInfo.toHtml(PfamScanSedaPluginInfo.itemsListToGuiString(PARAM_EMAIL_HELP_ITEMS, "A valid e-mail address. This is required by EMBL-EBI so they can contact you in the event of: "));
    public static final String PARAM_ACTIVE_SITE_PREDICTION_NAME = "active-site-prediction";
    public static final String PARAM_ACTIVE_SITE_PREDICTION_SHORT_NAME = "asp";
    public static final String PARAM_ACTIVE_SITE_PREDICTION_DESCRIPTION = "Active site prediction";
    public static final String PARAM_ACTIVE_SITE_PREDICTION_HELP = "Whether to predict active site residues for Pfam-A matches or not.";
    public static final String PARAM_ACTIVE_SITE_PREDICTION_HELP_GUI = "Whether to predict active site residues for Pfam-A matches or not.";
    public static final String PARAM_EVALUE_NAME = "evalue";
    public static final String PARAM_EVALUE_SHORT_NAME = "ev";
    public static final String PARAM_EVALUE_DESCRIPTION = "Expectation value";
    public static final String PARAM_EVALUE_HELP = "Optionally, the expectation value cut-off.";
    public static final String PARAM_EVALUE_HELP_GUI = "Optionally, the expectation value cut-off.";
    public static final String PARAM_ERROR_POLICY_NAME = "error-policy";
    public static final String PARAM_ERROR_POLICY_SHORT_NAME = "ep";
    public static final String PARAM_ERROR_POLICY_DESCRIPTION = "Sequence error policy";
    private static final List<String> PARAM_ERROR_POLICY_HELP_ITALIC = Arrays.asList("Annotate sequence as error", "Ignore sequences", "Produce an error (stop operation)");
    private static final String[] PARAM_ERROR_POLICY_HELP_ENUM = new String[]{"If a sequence analysis fails, this is annotated as an error in the output FASTA", "If a sequence analysis fails, it is ignored and not included in the output FASTA.", "If a sequence analysis fails an error is produced and the whole operation is stopped."};
    public static final String PARAM_ERROR_POLICY_HELP = PfamScanSedaPluginInfo.longEnumStringForCli("The policy to apply with sequences that fail when analyzed with PfamScan.", PfamScanSedaPluginInfo.cliMap((Enum[])PfamScanSequenceErrorPolicy.values(), (String[])PARAM_ERROR_POLICY_HELP_ENUM));
    public static final String PARAM_ERROR_POLICY_HELP_GUI = PfamScanSedaPluginInfo.toHtml(PfamScanSedaPluginInfo.longEnumStringForGui("The policy to apply with sequences that fail when analyzed with PfamScan.", PfamScanSedaPluginInfo.guiMap((Enum[])PfamScanSequenceErrorPolicy.values(), (String[])PARAM_ERROR_POLICY_HELP_ENUM)), Collections.emptyList(), PARAM_ERROR_POLICY_HELP_ITALIC, false);
    public static final String PARAM_BATCH_DELAY_FACTOR_NAME = "batch-delay-factor";
    public static final String PARAM_BATCH_DELAY_FACTOR_SHORT_NAME = "bdf";
    public static final String PARAM_BATCH_DELAY_FACTOR_DESCRIPTION = "Batch delay factor";
    public static final String PARAM_BATCH_DELAY_FACTOR_HELP = "The delay factor between batches. SEDA runs PfamScan queries in batches of 30 sequences to meet the EMBL-EBI guidelines regarding the usage of resources. A delay factor of 1 means that SEDA waits a time between batches equal to the time required to analyze the first batch.";
    public static final String PARAM_BATCH_DELAY_FACTOR_HELP_GUI = PfamScanSedaPluginInfo.toHtml("The delay factor between batches. SEDA runs PfamScan queries in batches of 30 sequences to meet the EMBL-EBI guidelines regarding the usage of resources. A delay factor of 1 means that SEDA waits a time between batches equal to the time required to analyze the first batch.");
    public static final int DEFAULT_BATCH_DELAY_FACTOR = 1;
    public static final double DEFAULT_EVALUE = 10.0;
    public static final PfamScanSequenceErrorPolicy DEFAULT_ERROR_POLICY = PfamScanRequestConfiguration.DEFAULT_ERROR_POLICY;
}

